/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.adapter.util;

import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.model.sofia.Process;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public class ModelFileUtil {
    private static final String EXTENSION_MODEL = "diagram";

    public IFile findModelInWorkspace(IProcessInfo processInfo) {
        if (processInfo == null || processInfo.getProcessId() == null) {
            throw new IllegalArgumentException("the process info or the process id cant be null");
        }
        return this.findModelInWorkspace(processInfo.getProcessId());
    }

    public IFile findModelInWorkspace(String processId) {
        IProject[] projects;
        IProject[] iProjectArray = projects = ResourcesPlugin.getWorkspace().getRoot().getProjects();
        int n = projects.length;
        int n2 = 0;
        while (n2 < n) {
            IProject project = iProjectArray[n2];
            IFile found = this.findProcessModel(project.getLocationURI(), processId);
            if (found != null) {
                return found;
            }
            ++n2;
        }
        return null;
    }

    private IFile findProcessModel(java.net.URI pathToSearch, String processId) {
        IFile found = this.searchAllFiles(pathToSearch, processId);
        if (found != null) {
            return found;
        }
        return this.searchAllFolders(pathToSearch, processId);
    }

    private IFile searchAllFiles(java.net.URI pathToSearch, String processId) {
        IFile[] files;
        IFile[] iFileArray = files = ResourcesPlugin.getWorkspace().getRoot().findFilesForLocationURI(pathToSearch);
        int n = files.length;
        int n2 = 0;
        while (n2 < n) {
            IFile file = iFileArray[n2];
            Process p = this.getProcess(file);
            if (this.isWantedModel(p, processId)) {
                return file;
            }
            ++n2;
        }
        return null;
    }

    private boolean isWantedModel(Process p, String processId) {
        return p != null && processId.equals(p.getId());
    }

    private IFile searchAllFolders(java.net.URI pathToSearch, String processId) {
        IContainer[] containers;
        IContainer[] iContainerArray = containers = ResourcesPlugin.getWorkspace().getRoot().findContainersForLocationURI(pathToSearch);
        int n = containers.length;
        int n2 = 0;
        while (n2 < n) {
            IContainer container = iContainerArray[n2];
            try {
                IResource[] resources;
                IResource[] iResourceArray = resources = container.members();
                int n3 = resources.length;
                int n4 = 0;
                while (n4 < n3) {
                    IFile f;
                    IResource res = iResourceArray[n4];
                    if (!pathToSearch.equals(res.getLocationURI()) && (f = this.findProcessModel(res.getLocationURI(), processId)) != null) {
                        return f;
                    }
                    ++n4;
                }
            }
            catch (CoreException coreException) {}
            ++n2;
        }
        return null;
    }

    private Process getProcess(IFile file) {
        if (!EXTENSION_MODEL.equals(file.getFileExtension())) {
            return null;
        }
        ResourceSetImpl resSet = new ResourceSetImpl();
        Resource resource = resSet.getResource(URI.createURI((String)file.getFullPath().toString()), true);
        return (Process)resource.getContents().get(1);
    }
}

