/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.adapter.util;

import eu.vicci.process.adapter.EngineAdapter;
import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import java.net.InetAddress;
import java.net.UnknownHostException;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IProject;
import org.eclipse.core.resources.ResourcesPlugin;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.debug.core.ILaunchConfiguration;

public class AdapterUtil {
    private AdapterUtil() {
    }

    public static IFile getSourceFile(ILaunchConfiguration configuration) throws CoreException {
        String projectName = configuration.getAttribute("Project", "");
        if (projectName == null || projectName.isEmpty()) {
            return null;
        }
        IProject project = ResourcesPlugin.getWorkspace().getRoot().getProject(projectName);
        if (!project.exists()) {
            return null;
        }
        String fileName = configuration.getAttribute("File", "");
        if (fileName == null || fileName.isEmpty()) {
            return null;
        }
        IFile file = project.getFile(fileName);
        if (file.exists()) {
            return file;
        }
        return null;
    }

    public static String getClientName() {
        return AdapterUtil.getClientName(null);
    }

    public static String getClientName(String suffix) {
        String tmp = suffix == null ? "" : suffix;
        try {
            return String.valueOf(InetAddress.getLocalHost().getHostName()) + tmp;
        }
        catch (UnknownHostException e) {
            e.printStackTrace();
            return "UnknownClient" + tmp;
        }
    }

    public static IProcessEngineClient createClient() {
        return AdapterUtil.createClient(null);
    }

    public static IProcessEngineClient createClient(String nameSuffix) {
        String tmp = nameSuffix == null ? "" : nameSuffix;
        ProcessEngineClientBuilder builder = new ProcessEngineClientBuilder();
        return builder.withIp(AdapterUtil.getConfigValue("pref_Host")).withPort(AdapterUtil.getConfigValue("pref_Port")).withNamespace(AdapterUtil.getConfigValue("pref_Namespace")).withRealmName(AdapterUtil.getConfigValue("pref_Realm")).withName(AdapterUtil.getClientName(tmp)).build();
    }

    private static String getConfigValue(String key) {
        return EngineAdapter.getDefault().getPreferenceStore().getString(key);
    }
}

