/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.adapter.view.ui;

import eu.vicci.process.adapter.EngineAdapter;
import eu.vicci.process.adapter.util.AdapterUtil;
import eu.vicci.process.adapter.util.ModelFileUtil;
import eu.vicci.process.adapter.wizard.ConnectWizard;
import eu.vicci.process.adapter.wizard.StartValuesWizard;
import eu.vicci.process.client.core.ConnectionListener;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.graphiti.adapter.view.ui.IProcessListView;
import eu.vicci.process.graphiti.adapter.view.ui.PeersDialog;
import eu.vicci.process.graphiti.execution.interpreter.ProcessInterpreter;
import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditor;
import eu.vicci.process.graphiti.execution.ui.ExecuteProcessEditorInput;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.util.URI;
import org.eclipse.jface.dialogs.ErrorDialog;
import org.eclipse.jface.preference.IPreferenceStore;
import org.eclipse.jface.util.IPropertyChangeListener;
import org.eclipse.jface.util.PropertyChangeEvent;
import org.eclipse.jface.wizard.IWizard;
import org.eclipse.jface.wizard.WizardDialog;
import org.eclipse.swt.widgets.Display;
import org.eclipse.swt.widgets.Shell;
import org.eclipse.ui.IEditorInput;
import org.eclipse.ui.IWorkbenchPage;
import org.eclipse.ui.PartInitException;
import org.eclipse.ui.PlatformUI;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProcessListViewController {
    private static final Logger logger = LoggerFactory.getLogger(ProcessListViewController.class);
    private static final String CLIENT_SUFFIX = "Process_List_View";
    private IProcessListView view;
    private IProcessEngineClient client;
    private List<IProcessInfo> processInfos = new ArrayList<IProcessInfo>();
    private List<IProcessInstanceInfo> instanceInfos = new ArrayList<IProcessInstanceInfo>();
    private ProcessEngineListener engineListener = new ProcessEngineListener(){

        public void onProcessInstanceDeployed(IProcessInstanceInfo processInstanceInfo) {
            if (ProcessListViewController.this.containsProcessInstance(processInstanceInfo.getProcessInstanceId())) {
                return;
            }
            ProcessListViewController.this.instanceInfos.add(processInstanceInfo);
            ProcessListViewController.this.view.refreshLists();
        }

        public void onProcessDeployed(IProcessInfo processInfo) {
            if (ProcessListViewController.this.containsProcess(processInfo.getProcessId())) {
                return;
            }
            ProcessListViewController.this.processInfos.add(processInfo);
            ProcessListViewController.this.view.refreshLists();
        }
    };
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage message) {
            ProcessListViewController.this.instanceInfos.stream().filter(p -> p.getProcessInstanceId().equals(message.getProcessInstanceId())).forEach(p -> p.setState(message.getState()));
            ProcessListViewController.this.view.refreshLists();
        }
    };
    private ConnectionListener connectionListener = new ConnectionListener(){

        public void onDisconnect() {
            ProcessListViewController.this.view.clientIsConnected(false);
            ProcessListViewController.this.unregisterListeners();
        }

        public void onConnect() {
            ProcessListViewController.this.view.clientIsConnected(true);
            ProcessListViewController.this.registerListeners();
            ProcessListViewController.this.listProcesses();
        }
    };
    private IPropertyChangeListener propertyChangeListener = new IPropertyChangeListener(){

        public void propertyChange(PropertyChangeEvent event) {
            ProcessListViewController.this.tryConnect();
        }
    };

    public ProcessListViewController(IProcessListView view) {
        this.view = view;
        this.registerPreferenceListener();
    }

    public void showConnectWizard(Shell shell) {
        ConnectWizard wizard = new ConnectWizard();
        WizardDialog wizardDialog = new WizardDialog(shell, (IWizard)wizard);
        wizardDialog.open();
    }

    public List<IProcessInfo> getProcessInfos() {
        return this.processInfos;
    }

    public List<IProcessInstanceInfo> getInstanceInfos() {
        return this.instanceInfos;
    }

    public void tryConnect(Shell shell) {
        IPreferenceStore store = EngineAdapter.getDefault().getPreferenceStore();
        String pHost = store.getString("pref_Host");
        String pPort = store.getString("pref_Port");
        String pRealm = store.getString("pref_Realm");
        String pNS = store.getString("pref_Namespace");
        if (pHost.isEmpty() || pPort.isEmpty() || pRealm.isEmpty() || pNS.isEmpty()) {
            logger.warn("not all prefs are found for direct connecting");
            if (shell != null) {
                this.showConnectWizard(shell);
            }
        } else {
            this.connect(pHost, pPort, pRealm, pNS);
        }
    }

    public void tryConnect() {
        this.tryConnect(null);
    }

    public void startProcess(String processId) {
        String instanceId = this.client.deployProcessInstance(processId);
        try {
            Thread.sleep(2000L);
        }
        catch (Exception exception) {}
        ProcessInstance instance = this.client.getProcessInstanceInfos(instanceId);
        List<DataTypeInstance> dataTypeInstances = this.getDataTypeInstances(instance);
        Map<String, DataTypeInstance> startData = null;
        if (dataTypeInstances != null && !dataTypeInstances.isEmpty() && (startData = this.createStartData(dataTypeInstances, this.view.getViewShell())) == null) {
            logger.error("error happened while creating start values");
            return;
        }
        this.client.startProcessInstance(instanceId, startData);
    }

    public void viewDisposed() {
        this.unRegisterPreferenceListener();
        this.unregisterListeners();
        if (this.client != null) {
            this.client.close();
        }
    }

    public void viewLoaded() {
        this.tryConnect();
    }

    public void showProcessInExecutionEditor(IProcessInstanceInfo process) {
        ProcessInstance processInstance = this.client.getProcessInstanceInfos(process.getProcessInstanceId());
        if (processInstance == null) {
            this.showInstanceNotFoundError();
            return;
        }
        ModelFileUtil util = new ModelFileUtil();
        IFile file = util.findModelInWorkspace((IProcessInfo)process);
        if (file == null) {
            this.showNotFoundError();
            return;
        }
        Display.getDefault().asyncExec(() -> {
            ExecuteProcessEditor editor = this.openEditor(file);
            ProcessInterpreter interpreter = new ProcessInterpreter(editor, processInstance);
            interpreter.init();
            interpreter.schedule();
        });
    }

    public void showProcessInModelEditor(IProcessInfo process) {
        ModelFileUtil util = new ModelFileUtil();
        IFile file = util.findModelInWorkspace(process);
        if (file == null) {
            this.showNotFoundError();
        } else {
            logger.info("found model file: {}", (Object)file.getLocationURI().getPath());
            Display.getDefault().asyncExec(() -> this.openEditor(file));
        }
    }

    public void showPeers() {
        PeersDialog dialog = new PeersDialog(this.view.getViewShell(), this.client);
        dialog.setBlockOnOpen(false);
        dialog.open();
    }

    private ExecuteProcessEditor openEditor(IFile file) {
        IWorkbenchPage page = PlatformUI.getWorkbench().getActiveWorkbenchWindow().getActivePage();
        IPath path = file.getFullPath();
        URI uri = URI.createPlatformResourceURI((String)path.toString(), (boolean)true);
        ExecuteProcessEditorInput input = new ExecuteProcessEditorInput(uri);
        try {
            return (ExecuteProcessEditor)page.openEditor((IEditorInput)input, "eu.vicci.process.graphiti.execution.executeProcessEditor");
        }
        catch (PartInitException partInitException) {
            return null;
        }
    }

    private void showNotFoundError() {
        logger.warn("Process Model could not be found in the current workspace. Displaying the remote model is not supported so far.");
        ErrorDialog.openError((Shell)this.view.getViewShell(), (String)"Error", (String)"Cant show the Process Model", (IStatus)new Status(4, "eu.vicci.process.graphiti.adapter.view", "Process Model could not be found in the current workspace. Displaying the remote model is not supported so far."));
    }

    private void showInstanceNotFoundError() {
        logger.warn("Cant find process instance.");
        ErrorDialog.openError((Shell)this.view.getViewShell(), (String)"Error", (String)"Cant show the Process Model", (IStatus)new Status(4, "eu.vicci.process.graphiti.adapter.view", "Cant find process instance."));
    }

    private Map<String, DataTypeInstance> createStartData(List<DataTypeInstance> dataTypeInstances, Shell shell) {
        StartValuesWizard wizard = new StartValuesWizard(dataTypeInstances);
        WizardDialog dialog = new WizardDialog(shell, (IWizard)wizard);
        if (dialog.open() == 0) {
            return wizard.getStartValues();
        }
        return null;
    }

    private List<DataTypeInstance> getDataTypeInstances(ProcessInstance instance) {
        return instance.getPorts().stream().filter(p -> p instanceof StartDataPortInstance).map(p -> ((StartDataPortInstance)p).getDataInstance()).collect(Collectors.toList());
    }

    private void connect(String host, String port, String realm, String namespace) {
        logger.debug("connection to proteus on {}:{}", (Object)host, (Object)port);
        this.client = AdapterUtil.createClient((String)CLIENT_SUFFIX);
        boolean connected = this.client.connect();
        this.view.clientIsConnected(connected);
        if (connected) {
            this.listProcesses();
        }
        this.registerListeners();
    }

    private void listProcesses() {
        this.processInfos.clear();
        this.processInfos.addAll(this.client.listDeployedProcesses());
        this.instanceInfos.clear();
        this.instanceInfos.addAll(this.client.listProcessInstances());
        this.view.refreshLists();
    }

    private boolean containsProcess(String processId) {
        return this.processInfos.stream().anyMatch(p -> p.getProcessId().equals(processId));
    }

    private boolean containsProcessInstance(String instanceId) {
        return this.instanceInfos.stream().anyMatch(p -> p.getProcessInstanceId().equals(instanceId));
    }

    private void registerListeners() {
        this.client.addStateChangeListener(this.stateChangeListener);
        this.client.addConnectionListener(this.connectionListener);
        this.client.addProcessEngineListener(this.engineListener);
    }

    private void unregisterListeners() {
        if (this.client == null) {
            return;
        }
        this.client.removeStateChangeListener(this.stateChangeListener);
        this.client.removeConnectionListener(this.connectionListener);
        this.client.removeProcessEngineListener(this.engineListener);
    }

    private void registerPreferenceListener() {
        EngineAdapter.getDefault().getPreferenceStore().addPropertyChangeListener(this.propertyChangeListener);
    }

    private void unRegisterPreferenceListener() {
        EngineAdapter.getDefault().getPreferenceStore().removePropertyChangeListener(this.propertyChangeListener);
    }
}

