/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.graphiti.adapter.view.ui;

import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.distribution.core.PeerProfile;
import java.util.List;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.core.runtime.jobs.Job;
import org.eclipse.jface.dialogs.Dialog;
import org.eclipse.jface.viewers.ArrayContentProvider;
import org.eclipse.jface.viewers.CellLabelProvider;
import org.eclipse.jface.viewers.ColumnLabelProvider;
import org.eclipse.jface.viewers.IContentProvider;
import org.eclipse.jface.viewers.TableViewer;
import org.eclipse.jface.viewers.TableViewerColumn;
import org.eclipse.swt.widgets.Composite;
import org.eclipse.swt.widgets.Control;
import org.eclipse.swt.widgets.Shell;

public class PeersDialog
extends Dialog {
    private final IProcessEngineClient client;
    private TableViewer tableViewer;
    private Composite dialogComposite;

    protected PeersDialog(Shell parentShell, IProcessEngineClient client) {
        super(parentShell);
        this.client = client;
    }

    protected Control createDialogArea(Composite parent) {
        Composite container = (Composite)super.createDialogArea(parent);
        this.dialogComposite = parent.getParent();
        boolean viewEnabled = this.client != null && this.client.isConnected();
        this.tableViewer = new TableViewer(container, 68354);
        this.tableViewer.getTable().setEnabled(viewEnabled);
        this.tableViewer.setContentProvider((IContentProvider)ArrayContentProvider.getInstance());
        this.tableViewer.getTable().setHeaderVisible(true);
        this.createColumns();
        if (viewEnabled) {
            this.loadPeers();
        }
        return container;
    }

    protected void configureShell(Shell newShell) {
        super.configureShell(newShell);
        newShell.setText("Connected Peers");
    }

    protected void createButtonsForButtonBar(Composite parent) {
        this.createButton(parent, 0, "Ok", true);
    }

    private void createColumns() {
        TableViewerColumn cIP = new TableViewerColumn(this.tableViewer, 0);
        cIP.getColumn().setWidth(200);
        cIP.getColumn().setText("IP");
        cIP.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PeerProfile)element).getIp();
            }
        });
        TableViewerColumn cName = new TableViewerColumn(this.tableViewer, 0);
        cName.getColumn().setWidth(200);
        cName.getColumn().setText("Hostname");
        cName.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PeerProfile)element).getHostName();
            }
        });
        TableViewerColumn cID = new TableViewerColumn(this.tableViewer, 0);
        cID.getColumn().setWidth(200);
        cID.getColumn().setText("ID");
        cID.setLabelProvider((CellLabelProvider)new ColumnLabelProvider(){

            public String getText(Object element) {
                return ((PeerProfile)element).getPeerId();
            }
        });
    }

    private void loadPeers() {
        Job loadingPeers = new Job("Load Peers"){

            protected IStatus run(IProgressMonitor monitor) {
                List peers = PeersDialog.this.client.getRegisteredPeers();
                PeersDialog.this.updateUI(peers);
                return Status.OK_STATUS;
            }
        };
        loadingPeers.schedule();
    }

    private void updateUI(List<PeerProfile> peers) {
        this.tableViewer.getTable().getDisplay().asyncExec(() -> {
            this.tableViewer.setInput((Object)peers);
            this.tableViewer.refresh();
            this.dialogComposite.pack();
        });
    }
}

