/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.distribution.core;

import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.net.Inet4Address;
import java.net.UnknownHostException;
import java.util.List;
import java.util.UUID;

public class PeerProfile {
    @JsonProperty
    private String peerId;
    @JsonProperty
    private String ip;
    @JsonProperty
    private String hostName;
    @JsonProperty
    private boolean isSuperPeer;
    @JsonProperty
    private List<String> devices;

    @JsonIgnore
    public String getPeerId() {
        return this.peerId;
    }

    @JsonIgnore
    public String getIp() {
        return this.ip;
    }

    @JsonIgnore
    public String getHostName() {
        return this.hostName;
    }

    @JsonIgnore
    public boolean isSuperPeer() {
        return this.isSuperPeer;
    }

    @JsonIgnore
    public void setIp(String ip) {
        this.ip = ip;
    }

    public static PeerProfile create(boolean isSuperPeer) {
        PeerProfile profile = new PeerProfile();
        profile.peerId = UUID.randomUUID().toString();
        profile.isSuperPeer = isSuperPeer;
        try {
            profile.hostName = Inet4Address.getLocalHost().getHostName();
        }
        catch (UnknownHostException e) {
            throw new RuntimeException("cant create the client profile for the peer", e);
        }
        return profile;
    }

    public List<String> getDevices() {
        return this.devices;
    }

    public void setDevices(List<String> devices) {
        this.devices = devices;
    }
}

