/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.core;

import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonIgnore;
import com.fasterxml.jackson.annotation.JsonProperty;
import java.util.ArrayList;
import java.util.List;

public class ClientProfile {
    public static final String ClientBaseRpc = "http://vicci.eu/processes/client/";
    private String uuid;
    private String name;
    private List<String> topics;
    @JsonIgnore
    private String rpcBase;

    public ClientProfile(String name, String uuid) {
        this(name, uuid, new ArrayList<String>());
    }

    @JsonCreator
    public ClientProfile(@JsonProperty(value="name") String name, @JsonProperty(value="uuid") String uuid, @JsonProperty(value="topics") List<String> topics) {
        this.name = name;
        this.uuid = uuid;
        this.topics = topics;
        this.rpcBase = ClientBaseRpc + uuid + "/";
    }

    public String getName() {
        return this.name;
    }

    public String getUuid() {
        return this.uuid;
    }

    public void addTopic(String topic) {
        this.topics.add(topic);
    }

    public List<String> getTopics() {
        return this.topics;
    }

    public String getRpcBase() {
        return this.rpcBase;
    }

    public boolean equals(Object arg0) {
        if (!(arg0 instanceof ClientProfile)) {
            return false;
        }
        return ((ClientProfile)arg0).getRpcBase().equals(this.rpcBase);
    }
}

