/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.subscribers;

import eu.vicci.process.client.subscribers.AbstractSubscriber;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.model.util.ProcessInfo;
import eu.vicci.process.model.util.ProcessInstanceInfo;
import eu.vicci.process.model.util.messages.ProcessEngineUpdate;
import eu.vicci.process.model.util.messages.core.IProcessEngineUpdate;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import ws.wamp.jawampa.PubSubData;

public class EngineUpdateSubscriber
extends AbstractSubscriber<PubSubData, IProcessEngineUpdate> {
    private ProcessEngineListener engineListener;

    public EngineUpdateSubscriber(ProcessEngineListener engineListener) {
        super(null, "http://vicci.eu/processes/engine/update");
        this.engineListener = engineListener;
    }

    public void onNext(PubSubData arg0) {
        IProcessEngineUpdate update = (IProcessEngineUpdate)this.convertFromJson(arg0.arguments().get(0), ProcessEngineUpdate.class);
        this.processUpdate(update);
    }

    private void processUpdate(IProcessEngineUpdate update) {
        if (update == null) {
            return;
        }
        switch (update.getUpdateType()) {
            case PROCESS_DEPLOYED: {
                this.processDeployed(update);
                break;
            }
            case INSTANCE_DEPLOYED: {
                this.instanceDeployed(update);
                break;
            }
        }
    }

    private void processDeployed(IProcessEngineUpdate update) {
        IProcessInfo info = (IProcessInfo)update.getTypedPayload(ProcessInfo.class);
        if (info != null) {
            this.engineListener.onProcessDeployed(info);
        }
    }

    private void instanceDeployed(IProcessEngineUpdate update) {
        IProcessInstanceInfo info = (IProcessInstanceInfo)update.getTypedPayload(ProcessInstanceInfo.class);
        if (info != null) {
            this.engineListener.onProcessInstanceDeployed(info);
        }
    }
}

