/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.handlers;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.JavaType;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.type.CollectionType;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstance;
import java.io.IOException;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;
import ws.wamp.jawampa.Reply;

public abstract class AbstractClientHandler
extends Subscriber<Reply> {
    protected static final Logger LOGGER = LoggerFactory.getLogger(AbstractClientHandler.class);
    private static final int timeout = 120;
    private ObjectMapper mapper = new ObjectMapper();
    private boolean isFinished = false;
    private boolean hasError = false;
    private CountDownLatch countDownLatch = new CountDownLatch(1);
    protected String state = "waiting";

    public void onCompleted() {
        this.finished();
    }

    public void onError(Throwable arg0) {
        arg0.printStackTrace();
        this.hasError = true;
        this.state = "error";
        this.finished();
    }

    public boolean isFinished() {
        return this.isFinished;
    }

    protected void finished() {
        this.isFinished = true;
        if (this.countDownLatch != null) {
            this.countDownLatch.countDown();
        }
    }

    public boolean await() throws InterruptedException {
        return this.countDownLatch.await(120L, TimeUnit.SECONDS);
    }

    public boolean hasError() {
        return this.hasError;
    }

    public String getState() {
        return this.state;
    }

    protected final <T> T convertFromJson(String json, Class<T> clazz) {
        try {
            return (T)this.mapper.readValue(json, clazz);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final <T> T convertFromJson(JsonNode json, Class<T> clazz) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader tmpLoader = JSONProcessStepInstance.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(tmpLoader);
            Object object = this.mapper.readValue(json.toString(), clazz);
            return (T)object;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return null;
    }

    protected final <T> T convertFromJson(JsonNode json, TypeReference<T> reference) {
        try {
            return (T)this.mapper.readValue(json.toString(), reference);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final Object unsafeConvertFromJson(JsonNode json, TypeReference<?> reference) {
        try {
            return this.mapper.readValue(json.toString(), reference);
        }
        catch (IOException e) {
            e.printStackTrace();
            return null;
        }
    }

    protected final <T extends Collection<?>> T convertFromJsonToCollectionType(JsonNode json, Class<T> collectionClass, Class<?> elementClass) {
        ClassLoader oldLoader = Thread.currentThread().getContextClassLoader();
        try {
            ClassLoader tmpLoader = JSONProcessStepInstance.class.getClassLoader();
            Thread.currentThread().setContextClassLoader(tmpLoader);
            CollectionType type = this.mapper.getTypeFactory().constructCollectionType(collectionClass, elementClass);
            Collection collection = (Collection)this.mapper.readValue(json.toString(), (JavaType)type);
            return (T)collection;
        }
        catch (IOException e) {
            LOGGER.error(e.getMessage());
            e.printStackTrace();
        }
        finally {
            Thread.currentThread().setContextClassLoader(oldLoader);
        }
        return null;
    }
}

