/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.examples.humantask;

import eu.vicci.process.client.examples.AbstractProcessRunner;
import eu.vicci.process.model.sofia.ComplexType;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.sofiainstance.ComplexTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.util.HashMap;
import java.util.Map;
import java.util.Optional;

public class HumanTaskWithComplexDataTypeTest
extends AbstractProcessRunner {
    @Override
    protected String getModelFilePath() {
        return "processes/humanTask/complexTypeHumanTask.diagram";
    }

    public static void main(String[] args) {
        HumanTaskWithComplexDataTypeTest test = new HumanTaskWithComplexDataTypeTest();
        test.run();
    }

    @Override
    protected Map<String, DataTypeInstance> getInputParameter() {
        HashMap<String, DataTypeInstance> parameters = new HashMap<String, DataTypeInstance>();
        int instanceNumber = this.processInstanceInfo.getInstancenumber();
        String idSuffix = "_Instance_" + instanceNumber;
        ComplexTypeInstance personInfo = this.addPersonInfo(instanceNumber, idSuffix, parameters);
        this.addPersonName(instanceNumber, idSuffix, parameters, personInfo);
        this.addPhoneNumber(instanceNumber, idSuffix, parameters, personInfo);
        this.addAge(instanceNumber, idSuffix, parameters, personInfo);
        return parameters;
    }

    private ComplexTypeInstance addPersonInfo(int instanceNumber, String idSuffix, Map<String, DataTypeInstance> parameters) {
        ComplexTypeInstance personInfo = SofiaInstanceFactory.eINSTANCE.createComplexTypeInstance();
        ComplexType personInfoType = (ComplexType)this.getDataTypeByName("PersonInfo");
        HumanTaskWithComplexDataTypeTest.copyBaseInfosToInstance((DataType)personInfoType, (DataTypeInstance)personInfo, instanceNumber);
        parameters.put(personInfo.getIdOfOrigin(), (DataTypeInstance)personInfo);
        return personInfo;
    }

    private void addPersonName(int instanceNumber, String idSuffix, Map<String, DataTypeInstance> parameters, ComplexTypeInstance personInfo) {
        StringTypeInstance personName = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
        StringType personNameType = (StringType)this.getDataTypeByName("PersonName");
        HumanTaskWithComplexDataTypeTest.copyBaseInfosToInstance((DataType)personNameType, (DataTypeInstance)personName, instanceNumber);
        personName.setBelongsTo(personInfo);
        personName.setValue("Klaus");
        personName.setName("PersonName");
        personInfo.getSubtypes().add((Object)personName);
        parameters.put(personName.getIdOfOrigin(), (DataTypeInstance)personName);
    }

    private void addPhoneNumber(int instanceNumber, String idSuffix, Map<String, DataTypeInstance> parameters, ComplexTypeInstance personInfo) {
        StringTypeInstance phoneNumber = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
        StringType phoneNumberType = (StringType)this.getDataTypeByName("PhoneNumber");
        HumanTaskWithComplexDataTypeTest.copyBaseInfosToInstance((DataType)phoneNumberType, (DataTypeInstance)phoneNumber, instanceNumber);
        phoneNumber.setBelongsTo(personInfo);
        phoneNumber.setValue("555-6673");
        phoneNumber.setName("PhoneNumber");
        personInfo.getSubtypes().add((Object)phoneNumber);
        parameters.put(phoneNumber.getIdOfOrigin(), (DataTypeInstance)phoneNumber);
    }

    private void addAge(int instanceNumber, String idSuffix, Map<String, DataTypeInstance> parameters, ComplexTypeInstance personInfo) {
        IntegerTypeInstance age = SofiaInstanceFactory.eINSTANCE.createIntegerTypeInstance();
        IntegerType ageType = (IntegerType)this.getDataTypeByName("Age");
        HumanTaskWithComplexDataTypeTest.copyBaseInfosToInstance((DataType)ageType, (DataTypeInstance)age, instanceNumber);
        age.setBelongsTo(personInfo);
        age.setValue(66);
        age.setName("Age");
        personInfo.getSubtypes().add((Object)age);
        parameters.put(age.getIdOfOrigin(), (DataTypeInstance)age);
    }

    private DataType getDataTypeByName(String name) {
        Optional<DataType> typeInstance = this.processInfo.getDataTypeDefinitions().stream().filter(type -> name.equals(type.getName())).findFirst();
        if (typeInstance.isPresent()) {
            return typeInstance.get();
        }
        ComplexType personInfo = (ComplexType)this.processInfo.getDataTypeDefinitions().stream().filter(type -> "PersonInfo".equals(type.getName())).findFirst().get();
        return personInfo.getSubtypes().stream().filter(type -> name.equals(type.getName())).findFirst().get();
    }
}

