/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.examples;

import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.model.util.messages.core.IMessageReceiver;
import eu.vicci.process.model.util.messages.core.PeerMetrics;

public class SubscribeToMetrics {
    private static final String IP = "localhost";
    private static final String PORT = "8081";
    private static final int millis = 600000;
    IProcessEngineClient client;
    private IMessageReceiver<PeerMetrics> metricsReceiver = new IMessageReceiver<PeerMetrics>(){

        public void onMessage(PeerMetrics arg) {
            System.out.println("Peer:           " + arg.peerId);
            System.out.println("Has Battery:    " + arg.hasBattery);
            System.out.println("Battery Status: " + (arg.batteryStatus == null ? "unknown" : arg.batteryStatus));
            System.out.println();
        }
    };

    public static void main(String[] args) {
        final SubscribeToMetrics test = new SubscribeToMetrics();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Listening for 600000 millis");
                System.out.println();
                test.run();
            }
        });
        t.setName("SubscribeToMetrics_Worker");
        t.start();
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        test.closeClient();
    }

    public void run() {
        this.client = new ProcessEngineClientBuilder().withIp(IP).withPort(PORT).withName("Example Client").withNamespace("vicciWs").withRealmName("vicciRealm").build();
        this.client.connect();
        this.client.subscribeToTopic("http://vicci.eu/processes/peer/metrics", this.metricsReceiver, PeerMetrics.class);
    }

    public void closeClient() {
        this.client.close();
    }
}

