/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.examples;

import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;

public class JustListenToStateChanges {
    private static final String IP = "localhost";
    private static final String PORT = "8081";
    private static final int millis = 600000;
    IProcessEngineClient client;

    public static void main(String[] args) {
        final JustListenToStateChanges test = new JustListenToStateChanges();
        Thread t = new Thread(new Runnable(){

            @Override
            public void run() {
                System.out.println("Listening for 600000 millis");
                System.out.println();
                test.run();
            }
        });
        t.setName("JustListenToStateChanges_Worker");
        t.start();
        try {
            Thread.sleep(600000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        test.closeClient();
    }

    public void run() {
        this.client = new ProcessEngineClientBuilder().withIp(IP).withPort(PORT).withName("Example Client").withNamespace("vicciWs").withRealmName("vicciRealm").build();
        this.client.connect();
        this.client.addStateChangeListener(new StateChangeListener(){

            public void onMessage(IStateChangeMessage message) {
                JustListenToStateChanges.this.handleMessage(message);
            }
        });
    }

    public void closeClient() {
        this.client.close();
    }

    private void handleMessage(IStateChangeMessage message) {
        System.out.println("Message: ");
        System.out.println("Instance Id: " + message.getInstanceId());
        System.out.println(String.valueOf(message.getProcessName()) + " to state " + message.getState());
        System.out.println();
    }
}

