/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.examples;

import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofia.ListType;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.StartDataPort;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.ListTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.io.File;
import java.io.FileNotFoundException;
import java.util.HashMap;
import java.util.List;
import java.util.Scanner;
import org.eclipse.emf.ecore.util.EcoreUtil;

public class ClientTest {
    private static final String IP = "localhost";
    private static final String PORT = "8081";
    private IProcessEngineClient pec;
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            System.out.println(String.valueOf(System.currentTimeMillis()) + " " + arg.getProcessName() + " to state " + arg.getState());
        }
    };

    public static void main(String[] args) {
        ClientTest test = new ClientTest();
        test.run();
    }

    public void run() {
        this.pec = new ProcessEngineClientBuilder().withIp(IP).withPort(PORT).withName("Example Client").withNamespace("vicciWs").withRealmName("vicciRealm").build();
        this.pec.connect();
        this.pec.addStateChangeListener(this.stateChangeListener);
        this.pec.registerProcessExecutionClient();
        this.loadTestProcesses();
        try {
            Thread.sleep(20000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void loadTestProcesses() {
        System.out.println("Upload1");
        String processId1 = this.pec.uploadModelFile("processes/SeMiWaInvokeTest.diagram");
        System.out.println("Deploy1");
        this.pec.deployProcess(processId1);
        System.out.println("Upload2");
        String processId2 = this.pec.uploadModelFile("processes/rosinvoke.diagram");
        System.out.println("Deploy2");
        this.pec.deployProcess(processId2);
        System.out.println("Upload4");
        String processId4 = this.pec.uploadModelFile("processes/WeatherProcess.diagram");
        System.out.println("Deploy4");
        this.pec.deployProcess(processId4);
        System.out.println("Upload3");
        String processId3 = this.pec.uploadModelFile("processes/HumanTaskTest.diagram");
        System.out.println("Deploy3");
        this.pec.deployProcess(processId3);
        System.out.println("DeployInstance");
        this.pec.deployProcessInstance(processId3);
        System.out.println("Upload4");
        String processId = this.pec.uploadModelFile("processes/CoffeeMakerProcess.diagram");
        System.out.println("Deploy4");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Deploy4");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        HashMap<String, ListTypeInstance> inputData = new HashMap<String, ListTypeInstance>();
        Process p = this.pec.getProcessInfos(processId);
        for (Port port : p.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            StartDataPort sdp = (StartDataPort)port;
            DataType dt = sdp.getPortDatatype();
            String dtId = dt.getId();
            if (!(dt instanceof ListType)) continue;
            ListType lt = (ListType)dt;
            ListTypeInstance lti = SofiaInstanceFactory.eINSTANCE.createListTypeInstance();
            lti.setCollectionItemType(lt.getCollectionItemType());
            lti.setTypeId(lt.getId());
            lti.setName(lt.getName());
            lti.setInstanceId(String.valueOf(lt.getId()) + "instance");
            lti.setInstancenumber(1);
            lti.setDataTypeType((DataType)lt);
            if (lt.getCollectionItemType() instanceof StringType) {
                if (lt.getName().equals("AvailableCoffeeTypes")) {
                    StringTypeInstance strtiOne = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiOne.setName("CoffeeTypeArabica");
                    strtiOne.setInstanceId(EcoreUtil.generateUUID());
                    strtiOne.setValue("Arabica");
                    strtiOne.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiTwo = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiTwo.setName("CoffeeTypeRobusta");
                    strtiTwo.setInstanceId(EcoreUtil.generateUUID());
                    strtiTwo.setValue("Robusta");
                    strtiTwo.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiThree = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiThree.setName("CoffeeTypeExcelsa");
                    strtiThree.setInstanceId(EcoreUtil.generateUUID());
                    strtiThree.setValue("Excelsa");
                    strtiThree.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strtiOne);
                    lti.getSubtypes().add((Object)strtiTwo);
                    lti.getSubtypes().add((Object)strtiThree);
                } else {
                    StringTypeInstance strtiSugar = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiSugar.setName("Ingredient1");
                    strtiSugar.setInstanceId(EcoreUtil.generateUUID());
                    strtiSugar.setValue("Sugar");
                    strtiSugar.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiMilk = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiMilk.setName("Ingredient2");
                    strtiMilk.setInstanceId(EcoreUtil.generateUUID());
                    strtiMilk.setValue("Milk");
                    strtiMilk.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiLiqueur = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiLiqueur.setName("Ingredient3");
                    strtiLiqueur.setInstanceId(EcoreUtil.generateUUID());
                    strtiLiqueur.setValue("Liqueur");
                    strtiLiqueur.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strtiSugar);
                    lti.getSubtypes().add((Object)strtiMilk);
                    lti.getSubtypes().add((Object)strtiLiqueur);
                }
            }
            inputData.put(dtId, lti);
        }
        this.pec.startProcessInstance(instanceId, inputData);
    }

    private void testCoffeeExtended() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/CoffeeMakerProcess.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        HashMap<String, ListTypeInstance> inputData = new HashMap<String, ListTypeInstance>();
        Process p = this.pec.getProcessInfos(processId);
        for (Port port : p.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            StartDataPort sdp = (StartDataPort)port;
            DataType dt = sdp.getPortDatatype();
            String dtId = dt.getId();
            if (!(dt instanceof ListType)) continue;
            ListType lt = (ListType)dt;
            ListTypeInstance lti = SofiaInstanceFactory.eINSTANCE.createListTypeInstance();
            lti.setCollectionItemType(lt.getCollectionItemType());
            lti.setTypeId(lt.getId());
            lti.setName(lt.getName());
            lti.setInstanceId(String.valueOf(lt.getId()) + "instance");
            lti.setInstancenumber(1);
            lti.setDataTypeType((DataType)lt);
            if (lt.getCollectionItemType() instanceof StringType) {
                if (lt.getName().equals("AvailableCoffeeTypes")) {
                    StringTypeInstance strtiOne = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiOne.setName("CoffeeTypeArabica");
                    strtiOne.setInstanceId(EcoreUtil.generateUUID());
                    strtiOne.setValue("Arabica");
                    strtiOne.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiTwo = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiTwo.setName("CoffeeTypeRobusta");
                    strtiTwo.setInstanceId(EcoreUtil.generateUUID());
                    strtiTwo.setValue("Robusta");
                    strtiTwo.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiThree = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiThree.setName("CoffeeTypeExcelsa");
                    strtiThree.setInstanceId(EcoreUtil.generateUUID());
                    strtiThree.setValue("Excelsa");
                    strtiThree.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strtiOne);
                    lti.getSubtypes().add((Object)strtiTwo);
                    lti.getSubtypes().add((Object)strtiThree);
                } else {
                    StringTypeInstance strtiSugar = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiSugar.setName("Ingredient1");
                    strtiSugar.setInstanceId(EcoreUtil.generateUUID());
                    strtiSugar.setValue("Sugar");
                    strtiSugar.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiMilk = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiMilk.setName("Ingredient2");
                    strtiMilk.setInstanceId(EcoreUtil.generateUUID());
                    strtiMilk.setValue("Milk");
                    strtiMilk.setDataTypeType(lt.getCollectionItemType());
                    StringTypeInstance strtiLiqueur = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strtiLiqueur.setName("Ingredient3");
                    strtiLiqueur.setInstanceId(EcoreUtil.generateUUID());
                    strtiLiqueur.setValue("Liqueur");
                    strtiLiqueur.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strtiSugar);
                    lti.getSubtypes().add((Object)strtiMilk);
                    lti.getSubtypes().add((Object)strtiLiqueur);
                }
            }
            inputData.put(dtId, lti);
        }
        this.pec.startProcessInstance(instanceId, inputData);
    }

    private void testPrintStep() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/LoadClassStepTest.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        this.pec.startProcessInstance(instanceId, null);
    }

    private void testHumanTaskWithInputInt() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/HumanTaskIntIn.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        HashMap<String, IntegerTypeInstance> inputData = new HashMap<String, IntegerTypeInstance>();
        Process p = this.pec.getProcessInfos(processId);
        for (Port port : p.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            StartDataPort sdp = (StartDataPort)port;
            DataType dt = sdp.getPortDatatype();
            String dtId = dt.getId();
            if (!(dt instanceof IntegerType)) continue;
            IntegerType it = (IntegerType)dt;
            IntegerTypeInstance iti = SofiaInstanceFactory.eINSTANCE.createIntegerTypeInstance();
            iti.setTypeId(it.getId());
            iti.setName(it.getName());
            iti.setInstanceId(String.valueOf(it.getId()) + "instance");
            iti.setInstancenumber(1);
            iti.setDataTypeType(dt);
            iti.setValue(666);
            inputData.put(dtId, iti);
        }
        System.out.println("Start instance");
        this.pec.startProcessInstance(instanceId, inputData);
    }

    private void testHumanTaskWithInputListMapping() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/HumanTaskListMapping.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        HashMap<String, ListTypeInstance> inputData = new HashMap<String, ListTypeInstance>();
        Process p = this.pec.getProcessInfos(processId);
        for (Port port : p.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            StartDataPort sdp = (StartDataPort)port;
            DataType dt = sdp.getPortDatatype();
            String dtId = dt.getId();
            if (!(dt instanceof ListType)) continue;
            ListType lt = (ListType)dt;
            ListTypeInstance lti = SofiaInstanceFactory.eINSTANCE.createListTypeInstance();
            lti.setCollectionItemType(lt.getCollectionItemType());
            lti.setTypeId(lt.getId());
            lti.setName(lt.getName());
            lti.setInstanceId(String.valueOf(lt.getId()) + "instance");
            lti.setInstancenumber(1);
            lti.setDataTypeType(dt);
            int i = 0;
            while (i < 5) {
                if (lt.getCollectionItemType() instanceof StringType) {
                    StringTypeInstance strti = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strti.setName("Name" + i);
                    strti.setInstanceId("Nameinstance" + i);
                    strti.setValue("NameValue" + i);
                    strti.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strti);
                }
                ++i;
            }
            inputData.put(dtId, lti);
        }
        System.out.println("Start instance");
        this.pec.startProcessInstance(instanceId, inputData);
        try {
            Thread.sleep(5000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        System.out.println("ProcessList " + this.pec.listProcessInstances().size());
        this.pec.getProcessInstanceInfos(instanceId);
    }

    private void testHumanTaskWithInputList() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/HumanTaskLists.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        HashMap<String, ListTypeInstance> inputData = new HashMap<String, ListTypeInstance>();
        Process p = this.pec.getProcessInfos(processId);
        for (Port port : p.getPorts()) {
            if (!(port instanceof StartDataPort)) continue;
            StartDataPort sdp = (StartDataPort)port;
            DataType dt = sdp.getPortDatatype();
            String dtId = dt.getId();
            if (!(dt instanceof ListType)) continue;
            ListType lt = (ListType)dt;
            ListTypeInstance lti = SofiaInstanceFactory.eINSTANCE.createListTypeInstance();
            lti.setCollectionItemType(lt.getCollectionItemType());
            lti.setTypeId(lt.getId());
            lti.setName(lt.getName());
            lti.setInstanceId(String.valueOf(lt.getId()) + "instance");
            lti.setInstancenumber(1);
            lti.setDataTypeType(dt);
            int i = 0;
            while (i < 5) {
                if (lt.getCollectionItemType() instanceof StringType) {
                    StringTypeInstance strti = SofiaInstanceFactory.eINSTANCE.createStringTypeInstance();
                    strti.setName("Name" + i);
                    strti.setInstanceId("Nameinstance" + i);
                    strti.setValue("NameValue" + i);
                    strti.setDataTypeType(lt.getCollectionItemType());
                    lti.getSubtypes().add((Object)strti);
                }
                ++i;
            }
            inputData.put(dtId, lti);
        }
        System.out.println("Start instance");
    }

    private void testCoffee() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/CoffeeProcess.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        this.pec.startProcessInstance(instanceId, null);
    }

    private void testSeMiWaInvoke() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/exampleProcess.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        this.pec.startProcessInstance(instanceId, null);
    }

    private void testRosInvoke() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/rosinvoke.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        this.pec.startProcessInstance(instanceId, null);
    }

    private void testHumanTask() {
        System.out.println("Upload");
        String processId = this.pec.uploadModelFile("processes/HumanTaskTest2.diagram");
        System.out.println("Deploy");
        this.pec.deployProcess(processId);
        System.out.println("DeployInstance");
        String instanceId = this.pec.deployProcessInstance(processId);
        System.out.println("Id: " + instanceId);
        System.out.println("Start");
        this.pec.startProcessInstance(instanceId, null);
    }

    private void uploadModel() {
        String text = "";
        File file = new File("processes/HumanTaskTest.diagram");
        try {
            Scanner scanner = new Scanner(file);
            scanner.useDelimiter("\\z");
            text = scanner.next();
            scanner.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        boolean isDiagram = false;
        this.pec.uploadProcessDefinition("HumanTaskTest", text, isDiagram);
    }

    private void listModels() {
        List processmodels = this.pec.listUploadedProcessDefinitions();
        System.out.println("Uploaded Models: ");
        for (String proc : processmodels) {
            System.out.println(proc);
        }
    }

    private void uploadModelFile() {
        this.pec.uploadModelFile("processes/HumanTaskTest.sofia");
    }

    private void deployModel() {
        this.pec.deployProcess("HumanTaskTest");
    }

    private void listDeployedModels() {
        List deployedmodels = this.pec.listDeployedProcesses();
        System.out.println("DeployedModels: ");
        for (IProcessInfo proc : deployedmodels) {
            System.out.println(proc.getProcessId());
            System.out.println(proc.getProcessName());
            System.out.println(proc.getProcessType());
            System.out.println(proc.getProcessDescription());
        }
    }

    private void getProcessDefinition() {
        System.out.println("MODEL:" + this.pec.getProcessDefinition("Pid1"));
    }

    private void getProcessInfos() {
        Process p = this.pec.getProcessInfos("Pid1");
        System.out.println(p.getDescription());
    }
}

