/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.examples;

import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.util.messages.core.HumanTaskRequestListener;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import java.io.IOException;
import java.util.Collections;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.apache.log4j.xml.DOMConfigurator;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;

public abstract class AbstractProcessRunner {
    protected IProcessEngineClient pec;
    protected CountDownLatch termination = new CountDownLatch(1);
    protected String rootInstanceId;
    protected Process processInfo;
    protected ProcessInstance processInstanceInfo;
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            AbstractProcessRunner.this.onStateChange(arg);
        }
    };
    private HumanTaskRequestListener humanTaskRequestListener = new HumanTaskRequestListener(){

        public void onMessage(IHumanTaskRequest arg) {
            AbstractProcessRunner.this.onHumanTaskRequest(arg);
        }
    };

    public AbstractProcessRunner() {
        DOMConfigurator.configure((String)"client_log4j.xml");
    }

    public void run() {
        this.createClient();
        this.pec.connect();
        this.pec.addStateChangeListener(this.stateChangeListener);
        this.pec.addHumanTaskRequestListener(this.humanTaskRequestListener);
        this.loadAndStartProcess();
        try {
            this.termination.await();
            Thread.sleep(2000L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.pec.close();
    }

    protected abstract String getModelFilePath();

    protected Map<String, DataTypeInstance> getInputParameter() {
        return null;
    }

    protected boolean doProcessChangesBeforeUploading() {
        return false;
    }

    protected void doProcessChange(Process process) {
    }

    protected String getIp() {
        return "localhost";
    }

    protected String getPort() {
        return "8081";
    }

    private void changeProcessBeforeUploading() {
        String path = this.getModelFilePath();
        Process model = null;
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        Resource resource = resSet.getResource(URI.createURI((String)path), true);
        model = path.endsWith(".diagram") ? (Process)resource.getContents().get(1) : (Process)resource.getContents().get(0);
        this.doProcessChange(model);
        try {
            resource.save(Collections.EMPTY_MAP);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    protected void loadAndStartProcess() {
        if (this.doProcessChangesBeforeUploading()) {
            System.out.println("edit model before uploading...");
            this.changeProcessBeforeUploading();
        }
        System.out.println("upload model file...");
        String processId = this.pec.uploadModelFile(this.getModelFilePath());
        System.out.println("model id: " + processId);
        System.out.println("deploy " + processId + "...");
        this.pec.deployProcess(processId);
        System.out.println("deploy instance for " + processId + "...");
        this.rootInstanceId = this.pec.deployProcessInstance(processId);
        System.out.println("instance id: " + this.rootInstanceId);
        try {
            Thread.sleep(1500L);
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        this.processInstanceInfo = this.pec.getProcessInstanceInfos(this.rootInstanceId);
        this.processInfo = this.pec.getProcessInfos(processId);
        System.out.print("Start execution for " + this.rootInstanceId + "...");
        this.pec.startProcessInstance(this.rootInstanceId, this.getInputParameter());
    }

    private void createClient() {
        this.pec = new ProcessEngineClientBuilder().withIp(this.getIp()).withPort(this.getPort()).withName("Example Client").withNamespace("vicciWs").withRealmName("vicciRealm").build();
    }

    protected void println(String txt) {
        System.out.println(txt);
    }

    protected void onStateChange(IStateChangeMessage arg) {
        if (!arg.getProcessInstanceId().equals(this.rootInstanceId)) {
            return;
        }
        this.println("");
        this.println(String.valueOf(arg.getProcessName()) + " changed to " + arg.getState().toString());
        if (arg.getInstanceId().equals(this.rootInstanceId) && (State.EXECUTED == arg.getState() || State.FAILED == arg.getState())) {
            this.termination.countDown();
        }
    }

    protected void onHumanTaskRequest(IHumanTaskRequest arg) {
        this.println("");
        this.println("Received HumanTask: " + arg.getName());
    }

    protected static void copyBaseInfosToInstance(DataType type, DataTypeInstance typeInstance, int instanceNumber) {
        typeInstance.setName(type.getName());
        typeInstance.setIdOfOrigin(type.getId());
        typeInstance.setInstanceId(String.valueOf(type.getId()) + "_Instance_" + instanceNumber);
        typeInstance.setInstancenumber(instanceNumber);
        typeInstance.setTypeId(type.getId());
        typeInstance.setDataTypeType(type);
    }
}

