/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client;

import eu.vicci.process.client.core.AbstractClientBuilder;
import eu.vicci.process.client.core.ClientProfile;
import eu.vicci.process.client.core.ConnectionListener;
import eu.vicci.process.client.core.IProcessEngineClient;
import eu.vicci.process.client.handlers.AbstractClientHandler;
import eu.vicci.process.client.handlers.DeployInstanceHandler;
import eu.vicci.process.client.handlers.DeployModelHandler;
import eu.vicci.process.client.handlers.DeployProcessHandler;
import eu.vicci.process.client.handlers.ExecuteProcessStepHandler;
import eu.vicci.process.client.handlers.InstanceConfigurationHandler;
import eu.vicci.process.client.handlers.ModelListHandler;
import eu.vicci.process.client.handlers.PauseInstanceHandler;
import eu.vicci.process.client.handlers.ProcessDocumentHandler;
import eu.vicci.process.client.handlers.ProcessInfosHandler;
import eu.vicci.process.client.handlers.ProcessInstanceInfosHandler;
import eu.vicci.process.client.handlers.ProcessInstanceInfosReducedHandler;
import eu.vicci.process.client.handlers.ProcessInstanceListHandler;
import eu.vicci.process.client.handlers.ProcessListHandler;
import eu.vicci.process.client.handlers.RegisterClientHandler;
import eu.vicci.process.client.handlers.RemoveInstanceHandler;
import eu.vicci.process.client.handlers.ResumeInstanceHandler;
import eu.vicci.process.client.handlers.RetrieveInstanceLogHandler;
import eu.vicci.process.client.handlers.RetrieveInstanceStateHandler;
import eu.vicci.process.client.handlers.RetrieveRecentStateChangesHandler;
import eu.vicci.process.client.handlers.RetrieveRegisteredPeersClientHandler;
import eu.vicci.process.client.handlers.StartInstanceHandler;
import eu.vicci.process.client.handlers.StopInstanceHandler;
import eu.vicci.process.client.handlers.UploadAndDeployHandler;
import eu.vicci.process.client.handlers.UploadModelHandler;
import eu.vicci.process.client.subscribers.EngineUpdateSubscriber;
import eu.vicci.process.client.subscribers.FeedbackServiceSubscriber;
import eu.vicci.process.client.subscribers.GenericSubscriber;
import eu.vicci.process.client.subscribers.HumanTaskRequestSubscriber;
import eu.vicci.process.client.subscribers.HumanTaskResponseSubscriber;
import eu.vicci.process.client.subscribers.StateChangeMessageSubscriber;
import eu.vicci.process.distribution.core.PeerProfile;
import eu.vicci.process.engine.core.ClientBuilderFactory;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofia.SofiaPackage;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.SofiaInstancePackage;
import eu.vicci.process.model.util.ConfigureInstanceRequest;
import eu.vicci.process.model.util.ExecuteProcessStepRequest;
import eu.vicci.process.model.util.ProcessStartRequest;
import eu.vicci.process.model.util.UploadModelRequest;
import eu.vicci.process.model.util.Utility;
import eu.vicci.process.model.util.messages.core.CompensationRequest;
import eu.vicci.process.model.util.messages.core.FeedbackServiceListener;
import eu.vicci.process.model.util.messages.core.HumanTaskRequestListener;
import eu.vicci.process.model.util.messages.core.HumanTaskResponseListener;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IHumanTaskResponse;
import eu.vicci.process.model.util.messages.core.IMessageReceiver;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.IWampMessage;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import java.io.IOException;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.eclipse.emf.ecore.xmi.impl.XMLResourceImpl;
import org.eclipse.emf.ecore.xmi.util.XMLProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.xml.sax.InputSource;
import rx.Subscriber;
import ws.wamp.jawampa.WampClient;
import ws.wamp.jawampa.WampClientBuilder;
import ws.wamp.jawampa.connection.IWampClientConnectionConfig;
import ws.wamp.jawampa.connection.IWampConnectorProvider;
import ws.wamp.jawampa.transport.netty.NettyWampClientConnectorProvider;
import ws.wamp.jawampa.transport.netty.NettyWampConnectionConfig;

public class ProcessEngineClient
implements IProcessEngineClient {
    private static final Logger logger = LoggerFactory.getLogger(ProcessEngineClient.class);
    private static final int CONNECT_TIMEOUT = 5;
    public static final int MAX_FRAME_PAYLOAD_LENGHT = 0x1000000;
    private String uuid = UUID.randomUUID().toString();
    private final String ip;
    private final String port;
    private final String name;
    private final String namespace;
    private final String realmName;
    private final boolean isServer;
    private boolean isConnected;
    private WampClient client;
    private List<ConnectionListener> connectionListeners = new ArrayList<ConnectionListener>();
    private List<StateChangeListener> stateChangeListeners = new ArrayList<StateChangeListener>();
    private List<HumanTaskRequestListener> humanTaskRequestListeners = new ArrayList<HumanTaskRequestListener>();
    private List<HumanTaskResponseListener> humanTaskResponseListeners = new ArrayList<HumanTaskResponseListener>();
    private List<ProcessEngineListener> processEngineListeners = new ArrayList<ProcessEngineListener>();
    private List<FeedbackServiceListener> feedbackServiceListeners = new ArrayList<FeedbackServiceListener>();
    public static final String DEFAULT_REALM = "vicciRealm";
    public static final String DEFAULT_NAMESPACE = "vicciWs";
    private StateChangeListener stateChangeMessageListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            ProcessEngineClient.this.stateChangeListeners.stream().forEach(l -> l.onMessage((IWampMessage)arg));
        }
    };
    private HumanTaskRequestListener humanTaskRequestListener = new HumanTaskRequestListener(){

        public void onMessage(IHumanTaskRequest arg) {
            ProcessEngineClient.this.humanTaskRequestListeners.stream().forEach(l -> l.onMessage((IWampMessage)arg));
        }
    };
    private HumanTaskResponseListener humanTaskResponseListener = new HumanTaskResponseListener(){

        public void onMessage(IHumanTaskResponse arg) {
            ProcessEngineClient.this.humanTaskResponseListeners.stream().forEach(l -> l.onMessage((IWampMessage)arg));
        }
    };
    private ProcessEngineListener privateEngineListner = new ProcessEngineListener(){

        public void onProcessInstanceDeployed(IProcessInstanceInfo processInstanceInfo) {
            ProcessEngineClient.this.processEngineListeners.stream().forEach(l -> l.onProcessInstanceDeployed(processInstanceInfo));
        }

        public void onProcessDeployed(IProcessInfo processInfo) {
            ProcessEngineClient.this.processEngineListeners.stream().forEach(l -> l.onProcessDeployed(processInfo));
        }
    };
    private FeedbackServiceListener feedbackServiceListener = new FeedbackServiceListener(){

        public void onMessage(CompensationRequest compensationRequest) {
            ProcessEngineClient.this.feedbackServiceListeners.forEach(l -> l.onMessage((IWampMessage)compensationRequest));
        }
    };

    public ProcessEngineClient(String name, String ip, String port, String realmName, String namespace, boolean isServer) {
        this.name = name;
        this.ip = ip;
        this.port = port;
        this.namespace = namespace;
        this.realmName = realmName;
        this.isServer = isServer;
        SofiaPackage.eINSTANCE.eClass();
        SofiaInstancePackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("diagram", new XMIResourceFactoryImpl());
        m.put("sofia", new XMIResourceFactoryImpl());
        m.put("sofiainstance", new XMIResourceFactoryImpl());
    }

    public boolean connect() {
        NettyWampClientConnectorProvider connectorProvider = new NettyWampClientConnectorProvider();
        WampClientBuilder builder = new WampClientBuilder();
        CountDownLatch waitTillConnected = new CountDownLatch(1);
        try {
            builder.withConnectorProvider((IWampConnectorProvider)connectorProvider).withUri("ws://" + this.ip + ":" + this.port + "/" + this.namespace).withRealm(this.realmName).withInfiniteReconnects().withReconnectInterval(3, TimeUnit.SECONDS).withConnectionConfiguration((IWampClientConnectionConfig)this.getNettyWampConfig());
            this.client = builder.build();
            this.registerRpcHandlers(waitTillConnected);
            this.client.open();
            boolean noTimeoutHappened = waitTillConnected.await(5L, TimeUnit.SECONDS);
            return noTimeoutHappened;
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    private NettyWampConnectionConfig getNettyWampConfig() {
        return new NettyWampConnectionConfig.Builder().withMaxFramePayloadLength(0x1000000).build();
    }

    private void subscribe() {
        this.client.makeSubscription("http://vicci.eu/processes/statechange").subscribe((Subscriber)new StateChangeMessageSubscriber(this.stateChangeMessageListener));
        this.client.makeSubscription("http://vicci.eu/processes/humantaskreq").subscribe((Subscriber)new HumanTaskRequestSubscriber(this.humanTaskRequestListener));
        this.client.makeSubscription("http://vicci.eu/processes/humantaskresp").subscribe((Subscriber)new HumanTaskResponseSubscriber(this.humanTaskResponseListener));
        this.client.makeSubscription("http://vicci.eu/processes/engine/update").subscribe((Subscriber)new EngineUpdateSubscriber(this.privateEngineListner));
        this.client.makeSubscription("http://vicci.eu/processes/feedback/compensation").subscribe((Subscriber)new FeedbackServiceSubscriber((IMessageReceiver<CompensationRequest>)this.feedbackServiceListener));
    }

    private void registerRpcHandlers(CountDownLatch waitTillConnected) {
        this.client.statusChanged().subscribe(state -> {
            if (state instanceof WampClient.ConnectedState) {
                this.subscribe();
                this.isConnected = true;
                waitTillConnected.countDown();
                this.informConnectionListeners(true);
            }
            if (state instanceof WampClient.DisconnectedState) {
                this.isConnected = false;
                this.informConnectionListeners(false);
            }
        });
    }

    public String registerProcessExecutionClient() {
        RegisterClientHandler rch = new RegisterClientHandler();
        ClientProfile cp = new ClientProfile(this.name, this.uuid);
        cp.addTopic("printHello");
        this.client.registerProcedure(String.valueOf(cp.getRpcBase()) + "printHello").subscribe(request -> System.out.println("#### This is a procedure which can be executed by some client ####"));
        this.callRpc("http://vicci.eu/processes/registerclient", rch, cp);
        return rch.getState();
    }

    public String getUuid() {
        return this.uuid;
    }

    public String getIp() {
        return this.ip;
    }

    public String getPort() {
        return this.port;
    }

    public boolean isServer() {
        return this.isServer;
    }

    public String getName() {
        return this.name;
    }

    public void publish(String topic, Object payload) {
        this.client.publish(topic, new Object[]{payload});
    }

    public void publishHumanTask(IHumanTaskRequest payload) {
        this.publish("http://vicci.eu/processes/humantaskreq", payload);
    }

    public void publishCompensationRequest(CompensationRequest request) {
        this.publish("http://vicci.eu/processes/feedback/compensation", request);
    }

    public String uploadProcessDefinition(String processid, String processdocument, boolean isDiagram) {
        return this.uploadProcessDefinition(processid, processdocument, isDiagram, false);
    }

    public String uploadProcessDefinition(String processid, String processdocument, boolean isDiagram, boolean overrideExisting) {
        if (isDiagram) {
            Process model = ProcessEngineClient.getProcessFromDocument(processdocument);
            processdocument = ProcessEngineClient.getProcessAsString(model, null);
            isDiagram = false;
        }
        byte[] compressed = Utility.compress((String)processdocument);
        UploadModelRequest input = new UploadModelRequest(processid, compressed, isDiagram, overrideExisting);
        UploadModelHandler umh = new UploadModelHandler();
        this.callRpc("http://vicci.eu/processes/uploadmodel", umh, input);
        String state = umh.getState();
        return state;
    }

    private void callRpc(String rpcId, AbstractClientHandler receiver, Object payload) {
        if (payload == null) {
            this.client.call(rpcId, new Object[0]).subscribe((Subscriber)receiver);
        } else {
            this.client.call(rpcId, new Object[]{payload}).subscribe((Subscriber)receiver);
        }
        try {
            boolean isCountDown = receiver.await();
            if (!isCountDown) {
                logger.error("Timeout while waiting for reply for rpc: '{}'", (Object)rpcId);
            }
        }
        catch (InterruptedException interruptedException) {
            logger.error("Waiting for rpc was interrupted: '{}'", (Object)rpcId);
        }
    }

    private void callRpc(String rpcId, AbstractClientHandler receiver) {
        this.callRpc(rpcId, receiver, null);
    }

    public String uploadAndDeploy(Process process) {
        String text = ProcessEngineClient.getProcessAsString(process, null);
        this.printModel(text);
        byte[] compressed = Utility.compress((String)text);
        UploadModelRequest input = new UploadModelRequest(process.getId(), compressed, false);
        UploadAndDeployHandler uadh = new UploadAndDeployHandler();
        this.callRpc("http://vicci.eu/processes/uploadanddeploy", uadh, input);
        return uadh.getState();
    }

    public String deployProcess(String processid) {
        DeployModelHandler dmh = new DeployModelHandler();
        this.callRpc("http://vicci.eu/processes/deploymodel", dmh, processid);
        return dmh.getState();
    }

    public String deployProcess(Process process) {
        return this.deployProcessRemote(null, process);
    }

    public String deployProcessRemote(String peerId, Process process) {
        String text = ProcessEngineClient.getProcessAsString(process, null);
        String processId = process.getId();
        this.printModel(text);
        byte[] compressed = Utility.compress((String)text);
        UploadModelRequest input = new UploadModelRequest(processId, compressed, false);
        DeployProcessHandler dmh = new DeployProcessHandler();
        this.callRpc(ProcessEngineClient.createRpcId(peerId, "http://vicci.eu/processes/deployprocess"), dmh, input);
        return processId;
    }

    public String deployProcessInstance(String processId) {
        return this.deployProcessInstanceRemote(null, processId);
    }

    public String deployProcessInstanceRemote(String peerId, String processId) {
        DeployInstanceHandler dih = new DeployInstanceHandler();
        this.callRpc(ProcessEngineClient.createRpcId(peerId, "http://vicci.eu/processes/deployinstance"), dih, processId);
        System.out.println("Instance ID: " + dih.getInstanceId());
        return dih.getInstanceId();
    }

    public <T extends IWampMessage> void subscribeToTopic(String topicId, IMessageReceiver<T> receiver, Class<T> paramClass) {
        GenericSubscriber<T> subscriber = new GenericSubscriber<T>(receiver, topicId, paramClass);
        this.client.makeSubscription(topicId).subscribe(subscriber);
    }

    private static String createRpcId(String peerId, String rpcId) {
        return peerId == null ? rpcId : String.valueOf(rpcId) + "_" + peerId;
    }

    public String configureProcessInstance(String processInstanceId, String configuration) {
        InstanceConfigurationHandler ich = new InstanceConfigurationHandler();
        ConfigureInstanceRequest input = new ConfigureInstanceRequest(processInstanceId, configuration);
        this.callRpc("http://vicci.eu/processes/instanceconfiguration", ich, input);
        return ich.getState();
    }

    public String startProcessInstance(String processInstanceId, Map<String, DataTypeInstance> inputParameters) {
        return this.startProcessInstance(processInstanceId, inputParameters, false);
    }

    public String startProcessInstance(String processInstanceId, Map<String, DataTypeInstance> inputParameters, boolean runInLoop) {
        return this.startProcessInstance(processInstanceId, null, inputParameters, runInLoop);
    }

    public String startProcessInstance(String processInstanceId, String runningForInstanceId, Map<String, DataTypeInstance> inputParameters, boolean runInLoop) {
        return this.internalStartProcessInstance(null, processInstanceId, runningForInstanceId, inputParameters, runInLoop);
    }

    public String startProcessInstanceRemote(String peerId, String processInstanceId, String runningForInstanceId, Map<String, DataTypeInstance> inputParameters) {
        return this.internalStartProcessInstance(peerId, processInstanceId, runningForInstanceId, inputParameters, false);
    }

    private String internalStartProcessInstance(String peerId, String processInstanceId, String runningForInstanceId, Map<String, DataTypeInstance> inputParameters, boolean runInLoop) {
        if (runInLoop) {
            logger.warn("running in loop not implemented yet");
        }
        StartInstanceHandler sih = new StartInstanceHandler();
        HashMap<String, IJSONTypeInstance> ports = new HashMap<String, IJSONTypeInstance>();
        if (inputParameters != null) {
            for (String dtId : inputParameters.keySet()) {
                DataTypeInstance dti = inputParameters.get(dtId);
                IJSONTypeInstance json = JSONTypeInstanceSerializer.makeJSONTypeInstance((DataTypeInstance)dti);
                ports.put(dtId, json);
            }
        } else {
            ports = null;
        }
        ProcessStartRequest input = new ProcessStartRequest(processInstanceId, runningForInstanceId, ports, runInLoop);
        this.callRpc(ProcessEngineClient.createRpcId(peerId, "http://vicci.eu/processes/startinstance"), sih, input);
        return null;
    }

    public String stopProcessInstance(String processInstanceId) {
        StopInstanceHandler stih = new StopInstanceHandler();
        this.callRpc("http://vicci.eu/processes/stopinstance", stih, processInstanceId);
        return stih.getState();
    }

    public String pauseProcessInstance(String processInstanceId) {
        PauseInstanceHandler pih = new PauseInstanceHandler();
        this.callRpc("http://vicci.eu/processes/pauseinstance", pih, processInstanceId);
        return pih.getState();
    }

    public String resumeProcessInstance(String processInstanceId) {
        ResumeInstanceHandler rih = new ResumeInstanceHandler();
        this.callRpc("http://vicci.eu/processes/resumeinstance", rih, processInstanceId);
        return rih.getState();
    }

    public String getProcessDefinition(String processid) {
        ProcessDocumentHandler pdh = new ProcessDocumentHandler();
        this.callRpc("http://vicci.eu/processes/processdoc", pdh, processid);
        return pdh.getDocument();
    }

    public List<String> listUploadedProcessDefinitions() {
        ModelListHandler mlh = new ModelListHandler();
        this.callRpc("http://vicci.eu/processes/listmodels", mlh);
        return mlh.getModelList();
    }

    public List<IProcessInfo> listDeployedProcesses() {
        ProcessListHandler plh = new ProcessListHandler();
        this.callRpc("http://vicci.eu/processes/processlist", plh);
        return plh.getProcessInfos();
    }

    public Process getProcessInfos(String processId) {
        ProcessInfosHandler pih = new ProcessInfosHandler();
        this.callRpc("http://vicci.eu/processes/processinfos", pih, processId);
        return pih.getProcess();
    }

    public ProcessInstance getProcessInstanceInfos(String processInstanceId) {
        ProcessInstanceInfosHandler piih = new ProcessInstanceInfosHandler();
        this.callRpc("http://vicci.eu/processes/processinstanceinfos", piih, processInstanceId);
        return piih.getProcessInstance();
    }

    public Map<String, String> getProcessInstanceInfosReduced(String processInstanceId) {
        ProcessInstanceInfosReducedHandler piirh = new ProcessInstanceInfosReducedHandler();
        this.callRpc("http://vicci.eu/processes/processinstanceinfosreduced", piirh, processInstanceId);
        return piirh.getProcessStepInstances();
    }

    public List<IProcessInstanceInfo> listProcessInstances() {
        ProcessInstanceListHandler pilh = new ProcessInstanceListHandler();
        this.callRpc("http://vicci.eu/processes/processinstancelist", pilh);
        return pilh.getProcessInstanceList();
    }

    public String uploadModelFile(String filepath) {
        return this.uploadModelFile(filepath, false);
    }

    public String uploadModelFile(String filepath, boolean overrideExisting) {
        Process model = null;
        ResourceSet resSet = this.getConfiguredResourceSet();
        Resource resource = resSet.getResource(URI.createURI((String)filepath), true);
        model = filepath.endsWith(".diagram") ? (Process)resource.getContents().get(1) : (Process)resource.getContents().get(0);
        String modelId = model.getId();
        String text = ProcessEngineClient.getProcessAsString(model, null);
        this.printModel(text);
        return this.uploadProcessDefinition(modelId, text, false, overrideExisting);
    }

    private ResourceSet getConfiguredResourceSet() {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        return resSet;
    }

    public String removeInstance(String processInstanceId) {
        RemoveInstanceHandler rih = new RemoveInstanceHandler();
        this.callRpc("http://vicci.eu/processes/removeinstance", rih, processInstanceId);
        return rih.getState();
    }

    public IStateChangeMessage getInstanceState(String processInstanceId) {
        RetrieveInstanceStateHandler rish = new RetrieveInstanceStateHandler();
        this.callRpc("http://vicci.eu/processes/instancestate", rish, processInstanceId);
        return rish.getScm();
    }

    public List<IStateChangeMessage> getInstanceLog(String processInstanceId) {
        RetrieveInstanceLogHandler rilh = new RetrieveInstanceLogHandler();
        this.callRpc("http://vicci.eu/processes/instancelog", rilh, processInstanceId);
        return rilh.getInstanceLog();
    }

    public List<IStateChangeMessage> getRecentStateChanges() {
        RetrieveRecentStateChangesHandler rrsch = new RetrieveRecentStateChangesHandler();
        this.callRpc("http://vicci.eu/processes/recentstatechanges", rrsch);
        return rrsch.getRecentStateChanges();
    }

    public ProcessStepInstance executeProcessStep(ProcessStepInstance psi, ProcessStep ps, boolean alreadyExecuting) {
        if (alreadyExecuting) {
            return null;
        }
        String text1 = "";
        XMLProcessor processor = new XMLProcessor();
        Resource res = ps.eResource();
        try {
            text1 = processor.saveToString(res, Collections.EMPTY_MAP);
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        String processInstanceString = JSONProcessStepInstanceSerializer.serialize((ProcessStepInstance)psi);
        ExecuteProcessStepRequest epr = new ExecuteProcessStepRequest();
        epr.setProcessStepInstance(processInstanceString);
        epr.setProcessStepModel(text1);
        ExecuteProcessStepHandler epsh = new ExecuteProcessStepHandler();
        this.callRpc("http://vicci.eu/processes/executeprocessstep", epsh, epr);
        String psiReturnString = epsh.getProcessInstanceString();
        ProcessStepInstance psiReturn = JSONProcessStepInstanceSerializer.deserialize((String)psiReturnString, (SofiaInstanceFactory)SofiaInstanceFactory.eINSTANCE);
        return psiReturn;
    }

    public List<PeerProfile> getRegisteredPeers() {
        RetrieveRegisteredPeersClientHandler handler = new RetrieveRegisteredPeersClientHandler();
        this.callRpc("http://vicci.eu/processes/registeredPeers", handler);
        return handler.getPeers();
    }

    public void close() {
        this.client.close().toBlocking().last();
    }

    public void setClientBuilderFactory(ClientBuilderFactory factory) {
    }

    public AbstractClientBuilder createNewClientBuilder() {
        return null;
    }

    public void loadExistingModels() {
    }

    public Map<String, String> getUploadedProcesses() {
        return null;
    }

    public void addConnectionListener(ConnectionListener listener) {
        if (!this.connectionListeners.contains(listener)) {
            this.connectionListeners.add(listener);
        }
    }

    public void removeConnectionListener(ConnectionListener listener) {
        this.connectionListeners.remove(listener);
    }

    public void addStateChangeListener(StateChangeListener stateChangeListener) {
        if (!this.stateChangeListeners.contains(stateChangeListener)) {
            this.stateChangeListeners.add(stateChangeListener);
        }
    }

    public void removeStateChangeListener(StateChangeListener stateChangeListener) {
        this.stateChangeListeners.remove(stateChangeListener);
    }

    public void addHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        if (!this.humanTaskRequestListeners.contains(humanTaskRequestListener)) {
            this.humanTaskRequestListeners.add(humanTaskRequestListener);
        }
    }

    public void removeHumanTaskRequestListener(HumanTaskRequestListener humanTaskRequestListener) {
        this.humanTaskRequestListeners.remove(humanTaskRequestListener);
    }

    public void addProcessEngineListener(ProcessEngineListener listener) {
        if (!this.processEngineListeners.contains(listener)) {
            this.processEngineListeners.add(listener);
        }
    }

    public void removeProcessEngineListener(ProcessEngineListener listener) {
        this.processEngineListeners.remove(listener);
    }

    public void addHumanTaskResponseLister(HumanTaskResponseListener listener) {
        if (!this.humanTaskResponseListeners.contains(listener)) {
            this.humanTaskResponseListeners.add(listener);
        }
    }

    public void removeHumanTaskResponseListener(HumanTaskResponseListener listener) {
        this.humanTaskResponseListeners.remove(listener);
    }

    public void addFeedbackServiceListener(FeedbackServiceListener listener) {
        this.feedbackServiceListeners.add(listener);
    }

    public void removeFeedbackServiceListener(FeedbackServiceListener listener) {
        this.feedbackServiceListeners.remove(listener);
    }

    private static String getProcessAsString(Process process, Map<?, ?> options) {
        String text = "";
        XMLResourceImpl resource = new XMLResourceImpl();
        XMLProcessor processor = new XMLProcessor();
        resource.getContents().add((Object)process);
        try {
            text = processor.saveToString((Resource)resource, options);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return text;
    }

    private static Process getProcessFromDocument(String document) {
        XMLResourceImpl res = new XMLResourceImpl();
        try {
            res.load(new InputSource(new StringReader(document)), null);
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        return (Process)res.getContents().get(1);
    }

    private void informConnectionListeners(boolean connected) {
        for (ConnectionListener connectionListener : this.connectionListeners) {
            if (connected) {
                connectionListener.onConnect();
                continue;
            }
            connectionListener.onDisconnect();
        }
    }

    public boolean isConnected() {
        return this.isConnected;
    }

    private void printModel(String text) {
        System.out.println("Text: \n" + text);
    }
}

