/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.openhab.util;

import com.google.gson.Gson;
import com.google.gson.JsonArray;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import com.google.gson.reflect.TypeToken;
import eu.vicci.openhab.util.IOpenHabRestClient;
import eu.vicci.openhab.util.beans.ExecuteGoalCommandBean;
import eu.vicci.openhab.util.beans.Goal;
import eu.vicci.openhab.util.beans.OpenHabItem;
import eu.vicci.openhab.util.beans.Quality;
import eu.vicci.openhab.util.beans.SemanticLocation;
import eu.vicci.process.devices.core.Sensor;
import eu.vicci.process.devices.events.core.EventType;
import eu.vicci.process.model.util.JsonUtil;
import eu.vicci.process.model.util.messages.core.SemanticPerson;
import java.io.IOException;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabRestClient
implements IOpenHabRestClient {
    private static final Logger logger = LoggerFactory.getLogger(OpenHabRestClient.class);
    private final String serverBaseUri;
    private CloseableHttpClient client;

    public OpenHabRestClient(String serverBaseUri) {
        this.serverBaseUri = serverBaseUri;
        this.client = HttpClients.createDefault();
    }

    @Override
    public String getOpenHabRestVersion() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest").build(new Object[0]);
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String json = this.getStringFromResponse(response);
        if (json == null || json.isEmpty()) {
            return null;
        }
        return JsonUtil.tryGetValueFromJsonObject((String)"version", (String)json);
    }

    @Override
    public String executeSelect(String queryStmt, boolean withLatest) {
        URI uri = this.getUriForSelectOrAsk(queryStmt, withLatest, "/rest/semantic/select");
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String json = this.getStringFromResponse(response);
        return json;
    }

    @Override
    public boolean executeAsk(String queryStmt, boolean withLatest) {
        URI uri = this.getUriForSelectOrAsk(queryStmt, withLatest, "/rest/semantic/ask");
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String json = this.getStringFromResponse(response);
        if (json == null || json.isEmpty()) {
            logger.error("Error while executing ask");
            return false;
        }
        return this.getBooleanFromJson(json);
    }

    @Override
    public String postCommandSemantic(String queryStmt, String command, boolean withLatest) {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("rest/semantic/post/command").build(new Object[0]);
        HttpPost post = new HttpPost(uri);
        JsonObject object = this.getPostCommandEntityAsJson(queryStmt, command, withLatest);
        String objString = object.toString();
        StringEntity entity = new StringEntity(objString, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        logger.debug("post entity: {}", (Object)objString);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)post);
        String json = this.getStringFromResponse(response);
        return json;
    }

    @Override
    public String getLocationForItem(String itemName) {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/semantic/select").path(itemName).path("/location").build(new Object[0]);
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String out = this.getStringFromResponse(response);
        if (out == null || out.compareToIgnoreCase("null") == 0) {
            return null;
        }
        return out;
    }

    @Override
    public String getSemanticType(String itemName) {
        return null;
    }

    @Override
    public List<OpenHabItem> getAllItems() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/items").build(new Object[0]);
        List list = this.receiveList(uri, new TypeToken<ArrayList<OpenHabItem>>(){});
        return list == null ? new ArrayList() : list;
    }

    @Override
    public List<SemanticPerson> getSemanticPersons() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/semantic/extended/persons").build(new Object[0]);
        return this.receiveList(uri, new TypeToken<ArrayList<SemanticPerson>>(){});
    }

    @Override
    public void close() {
        try {
            this.client.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    @Override
    public List<Sensor> getAllSensorsSemantic() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/semantic/sensors").build(new Object[0]);
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String json = this.getStringFromResponse(response);
        return this.getSensorListFromJson(json);
    }

    @Override
    public void postCommand(OpenHabItem item, String command) {
        throw new UnsupportedOperationException("not implemented yet");
    }

    @Override
    public List<SemanticLocation> getAllLocations() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/semantic/extended/locations").build(new Object[0]);
        return this.receiveList(uri, new TypeToken<ArrayList<SemanticLocation>>(){});
    }

    @Override
    public List<Quality> getAllQualities() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/goal/qualities").build(new Object[0]);
        return this.receiveList(uri, new TypeToken<ArrayList<Quality>>(){});
    }

    @Override
    public List<Goal> getAllGoals() {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/goal/goals").build(new Object[0]);
        return this.receiveList(uri, new TypeToken<ArrayList<Goal>>(){});
    }

    @Override
    public boolean executeGoal(ExecuteGoalCommandBean cmd) {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path("/rest/goal/execute/goal").build(new Object[0]);
        HttpPost post = new HttpPost(uri);
        String objString = this.getObjectAsJson(cmd);
        if (objString == null) {
            logger.error("Cant executeGoal. Parameter is null");
            return false;
        }
        StringEntity entity = new StringEntity(objString, ContentType.APPLICATION_JSON);
        post.setEntity((HttpEntity)entity);
        logger.debug("post entity: {}", (Object)objString);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)post);
        boolean isOk = this.isStatusOk(response.getStatusLine().getStatusCode());
        this.closeResponseSafely(response);
        return isOk;
    }

    private <T> T receiveList(URI uri, TypeToken<T> token) {
        HttpGet get = new HttpGet(uri);
        CloseableHttpResponse response = this.executeRequest((HttpUriRequest)get);
        String json = this.getStringFromResponse(response);
        return this.getObjectListFromJson(json, token);
    }

    private URI getUriForSelectOrAsk(String queryStmt, boolean withLatest, String path) {
        URI uri = UriBuilder.fromPath((String)this.serverBaseUri).path(path).queryParam("statement", new Object[]{"{stmt}"}).queryParam("withlatest", new Object[]{"{withlatest}"}).build(new Object[]{queryStmt, withLatest});
        return uri;
    }

    private String getStringFromResponse(CloseableHttpResponse response) {
        if (response == null) {
            return null;
        }
        if (!this.isStatusOk(response.getStatusLine().getStatusCode())) {
            return null;
        }
        String out = null;
        try {
            try {
                out = EntityUtils.toString((HttpEntity)response.getEntity());
            }
            catch (IOException e) {
                logger.error("error while reading entity from response");
                e.printStackTrace();
                try {
                    response.close();
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                response.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return out;
    }

    private String getObjectAsJson(Object src) {
        try {
            if (src != null) {
                return new Gson().toJson(src);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            logger.error("failed to convert object from class {} to json", (Object)src.getClass().getSimpleName());
        }
        return null;
    }

    private void closeResponseSafely(CloseableHttpResponse response) {
        if (response == null) {
            return;
        }
        try {
            response.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private boolean isStatusOk(int statusCode) {
        switch (statusCode) {
            case 200: 
            case 201: {
                return true;
            }
        }
        logger.error("Response status code not ok: {}", (Object)statusCode);
        return false;
    }

    private CloseableHttpResponse executeRequest(HttpUriRequest request) {
        CloseableHttpResponse response = null;
        try {
            response = this.client.execute(request);
        }
        catch (IOException e) {
            logger.error("error while executing httpget: {}", (Object)request.getURI().toString());
            e.printStackTrace();
        }
        return response;
    }

    private boolean getBooleanFromJson(String json) {
        JsonObject obj = JsonUtil.tryGetJsonObject((String)json);
        JsonElement element = obj.get("result");
        return element.getAsBoolean();
    }

    private JsonObject getPostCommandEntityAsJson(String statement, String command, boolean withLatest) {
        JsonObject object = new JsonObject();
        String tmp = statement.replace("\t", " ");
        object.addProperty("statement", tmp);
        object.addProperty("command", command);
        object.addProperty("withlatest", Boolean.valueOf(withLatest));
        return object;
    }

    private List<Sensor> getSensorListFromJson(String json) {
        ArrayList<Sensor> list = new ArrayList<Sensor>();
        JsonObject object = JsonUtil.tryGetJsonObject((String)json);
        JsonObject res = object.getAsJsonObject("results");
        JsonArray results = res.getAsJsonArray("bindings");
        for (JsonObject obj : results) {
            String uid = this.getObjectValueAsString("openHabName", "value", obj);
            String type = this.getObjectValueAsString("typeName", "value", obj);
            String location = this.getObjectValueAsString("location", "value", obj);
            String unit = this.getObjectValueAsString("symbol", "value", object);
            EventType et = new EventType(type, String.class);
            Sensor sensor = new Sensor(uid, location, type, et, String.class, unit);
            list.add(sensor);
        }
        return list;
    }

    private <T> T getObjectListFromJson(String json, TypeToken<T> token) {
        if (json == null) {
            return null;
        }
        Gson gson = new Gson();
        Object result = null;
        try {
            result = gson.fromJson(json, token.getType());
        }
        catch (Exception exception) {
            logger.error("error converting json result to class {}: {}", (Object)token.getType().getClass().getName(), (Object)json);
        }
        return (T)result;
    }

    private String getObjectValueAsString(String memberName, String memberValueField, JsonObject object) {
        if (!object.has(memberName)) {
            return null;
        }
        return object.getAsJsonObject(memberName).get(memberValueField).getAsString();
    }
}

