/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.rest.examples;

import eu.vicci.process.client.rest.ProteusRestClient;
import eu.vicci.process.client.rest.examples.AbstractExample;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import java.util.HashMap;
import java.util.Map;

public class RunWithInputParameter
extends AbstractExample {
    public static void main(String[] args) {
        new RunWithInputParameter().run();
    }

    @Override
    protected void run() {
        ProteusRestClient client = this.getClient();
        String diagram = RunWithInputParameter.readProcessDoc("processes/SimpleDataTypeProcess.diagram");
        String id = client.uploadAndDeploy(diagram);
        System.out.println("Process Id: " + id);
        String instanceId = client.deployProcessInstance(id);
        System.out.println("Process Instance Id: " + instanceId);
        this.enableWaitForInstance(instanceId);
        ProcessInstance processInstance = client.getProcessStepInstance(instanceId);
        Map<String, DataTypeInstance> inputParameters = this.createInputParams(processInstance);
        client.startProcessInstance(instanceId, inputParameters);
        this.waitForProcess();
        IStateChangeMessage finalMessage = client.getRecentState(instanceId);
        this.printAllEndportData(finalMessage);
    }

    private Map<String, DataTypeInstance> createInputParams(ProcessInstance processInstance) {
        DataPortInstance stringPort = (DataPortInstance)processInstance.getPorts().stream().filter(p -> p.getName().equals("string_port")).findFirst().get();
        DataPortInstance intPort = (DataPortInstance)processInstance.getPorts().stream().filter(p -> p.getName().equals("int_port")).findFirst().get();
        StringTypeInstance stringInstance = (StringTypeInstance)stringPort.getDataInstance();
        IntegerTypeInstance intInstance = (IntegerTypeInstance)intPort.getDataInstance();
        stringInstance.setValue("Hello World");
        intInstance.setValue(12345);
        HashMap<String, DataTypeInstance> params = new HashMap<String, DataTypeInstance>();
        params.put(stringInstance.getTypeId(), (DataTypeInstance)stringInstance);
        params.put(intInstance.getTypeId(), (DataTypeInstance)intInstance);
        return params;
    }

    private void printAllEndportData(IStateChangeMessage message) {
        System.out.println("\nFinished Instance has following values:\n");
        message.getEndDataPorts().values().stream().forEach(p -> System.out.println(p.getDataTypeInstance().getDataType().getName() + ":  " + p.getDataTypeInstance().getValueString()));
    }
}

