/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.rest.examples;

import eu.vicci.process.client.rest.ProteusRestClient;
import eu.vicci.process.model.util.messages.StateChangeMessage;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.Paths;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import org.glassfish.jersey.media.sse.EventSource;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;

public abstract class AbstractExample {
    private final ProteusRestClient client;
    private final String port;
    private final String host;
    private String processInstanceId;
    private Client sseClient;
    private CountDownLatch waitForProcess;

    public AbstractExample() {
        this("localhost", "8082");
    }

    public AbstractExample(String host, String port) {
        this.host = host;
        this.port = port;
        this.client = new ProteusRestClient(host, port);
    }

    protected ProteusRestClient getClient() {
        return this.client;
    }

    protected void enableWaitForInstance(String processInstanceId) {
        this.processInstanceId = processInstanceId;
        this.waitForProcess = new CountDownLatch(1);
        this.runSse();
    }

    protected void waitForProcess() {
        if (this.waitForProcess == null || this.processInstanceId == null) {
            throw new IllegalStateException("you have to call enableWaitForInstance() first");
        }
        try {
            this.waitForProcess.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    protected abstract void run();

    protected static String readProcessDoc(String filePath) {
        String doc = null;
        try {
            byte[] encoded = Files.readAllBytes(Paths.get(filePath, new String[0]));
            doc = new String(encoded);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return doc;
    }

    private void runSse() {
        this.sseClient = this.createSseClient();
        String uri = this.host + ":" + this.port + "/events/statechanges";
        if (!uri.startsWith("http")) {
            uri = "http://" + uri;
        }
        WebTarget target = this.sseClient.target(uri);
        EventSource eventSource = new EventSource(target, false){

            public void onEvent(InboundEvent inboundEvent) {
                IStateChangeMessage message = (IStateChangeMessage)inboundEvent.readData(StateChangeMessage.class);
                AbstractExample.this.onStateChangeInternal(message);
                AbstractExample.this.onStateChange(message);
            }
        };
        eventSource.open();
    }

    private void onStateChangeInternal(IStateChangeMessage message) {
        if (this.waitForProcess == null || this.processInstanceId == null) {
            return;
        }
        if (this.processInstanceId.equals(message.getInstanceId()) && this.isFinished(message)) {
            this.waitForProcess.countDown();
        }
    }

    protected void onStateChange(IStateChangeMessage message) {
        System.out.println(message.getProcessName() + " changed to " + message.getState().name());
    }

    private Client createSseClient() {
        return ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
    }

    private boolean isFinished(IStateChangeMessage message) {
        switch (message.getState()) {
            case EXECUTED: 
            case FAILED: 
            case DEACTIVATED: {
                return true;
            }
        }
        return false;
    }
}

