/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.client.rest;

import eu.vicci.process.client.core.UploadAndDeployRequest;
import eu.vicci.process.client.rest.JacksonDecoder;
import eu.vicci.process.client.rest.JacksonEncoder;
import eu.vicci.process.client.rest.RestClientInternal;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.ProcessInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstance;
import eu.vicci.process.model.util.serialization.jsontypeinstances.JSONTypeInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import feign.Feign;
import feign.codec.Decoder;
import feign.codec.Encoder;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class ProteusRestClient {
    private final RestClientInternal restClient;

    public ProteusRestClient() {
        this("localhost", "8082");
    }

    public ProteusRestClient(String host, String port) {
        ProteusRestClient.checkNullOrEmpty(host, "host");
        ProteusRestClient.checkNullOrEmpty(port, "port");
        this.restClient = ProteusRestClient.createRestClient(host, port);
    }

    private static void checkNullOrEmpty(String value, String name) {
        boolean check;
        boolean bl = check = value == null || value.isEmpty();
        if (check) {
            throw new IllegalArgumentException(name + " cant be null");
        }
    }

    private static RestClientInternal createRestClient(String host, String port) {
        if (!host.startsWith("http")) {
            host = "http://" + host;
        }
        host = host + ":" + port;
        return (RestClientInternal)Feign.builder().encoder((Encoder)new JacksonEncoder()).decoder((Decoder)new JacksonDecoder()).target(RestClientInternal.class, host);
    }

    public List<? extends IProcessInfo> listDeployedProcesses() {
        return this.restClient.listDeployedProcesses();
    }

    public List<? extends IProcessInstanceInfo> listDeployedProcessInstances() {
        return this.restClient.listDeployedProcessInstances();
    }

    public String uploadAndDeploy(String processDocument, boolean overrideExisting) {
        UploadAndDeployRequest request = new UploadAndDeployRequest();
        request.setProcessdocument(processDocument);
        request.setOverrideExisting(overrideExisting);
        return this.restClient.uploadAndDeploy(request);
    }

    public String uploadAndDeploy(String processDocument) {
        return this.uploadAndDeploy(processDocument, true);
    }

    public String deployProcessInstance(String processId) {
        return this.restClient.deployProcessInstance(processId);
    }

    public void startProcessInstance(String processInstanceId) {
        this.restClient.startProcessInstance(processInstanceId);
    }

    public void startProcessInstance(String processInstanceId, Map<String, DataTypeInstance> inputParameters) {
        Map<String, IJSONTypeInstance> convertedInput = ProteusRestClient.convertInputParameter(inputParameters);
        if (convertedInput == null) {
            this.restClient.startProcessInstance(processInstanceId);
        } else {
            this.restClient.startProcessInstance(processInstanceId, convertedInput);
        }
    }

    public ProcessInstance getProcessStepInstance(String processInstanceId) {
        JSONProcessStepInstance json = this.restClient.getProcessStepInstance(processInstanceId);
        ProcessInstance processInstance = (ProcessInstance)json.makeProcessStepInstance(SofiaInstanceFactory.eINSTANCE);
        return processInstance;
    }

    public IStateChangeMessage getRecentState(String processInstanceId) {
        return this.restClient.getRecentState(processInstanceId);
    }

    private static Map<String, IJSONTypeInstance> convertInputParameter(Map<String, DataTypeInstance> inputParameters) {
        if (inputParameters == null) {
            return null;
        }
        HashMap<String, IJSONTypeInstance> convertedInput = new HashMap<String, IJSONTypeInstance>();
        for (String dtId : inputParameters.keySet()) {
            DataTypeInstance dti = inputParameters.get(dtId);
            IJSONTypeInstance json = JSONTypeInstanceSerializer.makeJSONTypeInstance((DataTypeInstance)dti);
            convertedInput.put(dtId, json);
        }
        return convertedInput;
    }
}

