/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.wampserver.handlers;

import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import eu.vicci.process.model.util.ProcessStartRequest;
import eu.vicci.process.model.util.serialization.jsontypeinstances.core.IJSONTypeInstance;
import eu.vicci.process.wampserver.handlers.AbstractRpcHandlerManageable;
import java.util.HashMap;
import java.util.Map;
import ws.wamp.jawampa.Request;

public class StartInstanceServerHandler
extends AbstractRpcHandlerManageable {
    public StartInstanceServerHandler(IProcessManager processManager) {
        super(processManager);
    }

    public void onNext(Request t) {
        ProcessStartRequest request = this.convertFromJson(t.arguments().get(0), ProcessStartRequest.class);
        String processInstanceId = request.getProcessInstanceId();
        String originalProcessInstanceId = request.getRunningForInstanceId();
        Map ports = request.getPorts();
        Map<String, DataTypeInstance> inputParameters = this.deserializePorts(ports);
        boolean runInLoop = request.getRunInLoop();
        String state = this.processManager.startProcessInstance(processInstanceId, originalProcessInstanceId, inputParameters, runInLoop);
        t.reply(new Object[]{state});
    }

    private Map<String, DataTypeInstance> deserializePorts(Map<String, IJSONTypeInstance> ports) {
        if (ports == null) {
            return null;
        }
        HashMap<String, DataTypeInstance> inputParameters = new HashMap<String, DataTypeInstance>();
        for (String portName : ports.keySet()) {
            IJSONTypeInstance json = ports.get(portName);
            DataTypeInstance dti = json.makeDataTypeInstance((SofiaInstanceFactory)SofiaInstanceFactoryImplCustom.getInstance());
            inputParameters.put(portName, dti);
        }
        return inputParameters;
    }
}

