/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.wampserver.handlers;

import eu.vicci.openhab.util.OpenHabRestClient;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.wampserver.handlers.AbstractRpcHandler;
import java.util.List;
import ws.wamp.jawampa.ApplicationError;
import ws.wamp.jawampa.Request;

public class SemanticPersonsHandler
extends AbstractRpcHandler {
    private static final String httpBase = "http://";
    private static final String errMessage = "PROtEUS can\u00b4t connect to OpenHab SAL";
    private final String targetPath = this.createTargetPath();

    public void onNext(Request arg) {
        if (this.targetPath == null) {
            this.sendError(arg);
            return;
        }
        OpenHabRestClient client = new OpenHabRestClient(this.targetPath);
        List persons = client.getSemanticPersons();
        if (persons == null) {
            this.sendError(arg);
            return;
        }
        arg.reply(new Object[]{persons});
    }

    private String createTargetPath() {
        String tmp = ConfigurationManager.getInstance().getConfigAsString("OPENHAB_URI");
        if (tmp == null) {
            return null;
        }
        if (!tmp.startsWith(httpBase)) {
            tmp = httpBase + tmp;
        }
        if (tmp.endsWith("/")) {
            tmp = tmp.substring(0, tmp.length() - 1);
        }
        return tmp;
    }

    private void sendError(Request arg) {
        try {
            arg.replyError("jawampa.error.not_connected", new Object[]{errMessage});
        }
        catch (ApplicationError e) {
            e.printStackTrace();
        }
    }
}

