/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.wampserver;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import eu.vicci.process.client.ProcessEngineClientBuilder;
import eu.vicci.process.client.core.AbstractClientBuilder;
import eu.vicci.process.client.core.IConfigurationReader;
import eu.vicci.process.client.subscribers.HumanTaskResponseSubscriber;
import eu.vicci.process.distribution.core.PeerProfile;
import eu.vicci.process.distribution.core.SuperPeerRequest;
import eu.vicci.process.engine.core.ClientBuilderFactory;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.util.ConfigurationReader;
import eu.vicci.process.model.util.messages.HumanTaskMessageManager;
import eu.vicci.process.model.util.messages.ProcessEngineUpdate;
import eu.vicci.process.model.util.messages.core.HumanTaskRequestListener;
import eu.vicci.process.model.util.messages.core.HumanTaskResponseListener;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IHumanTaskResponse;
import eu.vicci.process.model.util.messages.core.IProcessEngineUpdate;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.PeerMetrics;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import eu.vicci.process.server.util.FeedbackServiceMonitor;
import eu.vicci.process.server.util.JacksonEncoder;
import eu.vicci.process.server.util.Util;
import eu.vicci.process.wampserver.Peer;
import eu.vicci.process.wampserver.handlers.AbstractRpcHandler;
import eu.vicci.process.wampserver.handlers.DeployInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.DeployModelServerHandler;
import eu.vicci.process.wampserver.handlers.DeployProcessServerHandler;
import eu.vicci.process.wampserver.handlers.ExecuteProcessStepServerHandler;
import eu.vicci.process.wampserver.handlers.InstanceConfigurationServerHandler;
import eu.vicci.process.wampserver.handlers.ModelListServerHandler;
import eu.vicci.process.wampserver.handlers.PauseInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessDocumentServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessInfosServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessInstanceInfosReducedServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessInstanceInfosServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessInstanceListServerHandler;
import eu.vicci.process.wampserver.handlers.ProcessListServerHandler;
import eu.vicci.process.wampserver.handlers.RegisterClientServerHandler;
import eu.vicci.process.wampserver.handlers.RegisterPeerServerHandler;
import eu.vicci.process.wampserver.handlers.RemoveInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.ResumeInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.RetrieveClosedHumanTaskResponses;
import eu.vicci.process.wampserver.handlers.RetrieveInstanceLogServerHandler;
import eu.vicci.process.wampserver.handlers.RetrieveInstanceStateServerHandler;
import eu.vicci.process.wampserver.handlers.RetrieveOpenHumanTaskRequestsHandler;
import eu.vicci.process.wampserver.handlers.RetrieveRecentStateChangesServerHandler;
import eu.vicci.process.wampserver.handlers.RetrieveRegisteredPeersListServerHandler;
import eu.vicci.process.wampserver.handlers.SemanticPersonsHandler;
import eu.vicci.process.wampserver.handlers.StartInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.StopInstanceServerHandler;
import eu.vicci.process.wampserver.handlers.UploadAndDeployServerHandler;
import eu.vicci.process.wampserver.handlers.UploadModelServerHandler;
import feign.Feign;
import feign.RetryableException;
import feign.codec.Encoder;
import java.net.URI;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import rx.Subscriber;
import ws.wamp.jawampa.ApplicationError;
import ws.wamp.jawampa.WampClient;
import ws.wamp.jawampa.WampClientBuilder;
import ws.wamp.jawampa.WampRouter;
import ws.wamp.jawampa.WampRouterBuilder;
import ws.wamp.jawampa.connection.IWampClientConnectionConfig;
import ws.wamp.jawampa.connection.IWampConnectorProvider;
import ws.wamp.jawampa.transport.netty.NettyWampClientConnectorProvider;
import ws.wamp.jawampa.transport.netty.NettyWampConnectionConfig;
import ws.wamp.jawampa.transport.netty.SimpleWampWebsocketListener;

public class SuperPeer {
    protected static final Logger LOG = LoggerFactory.getLogger(SuperPeer.class);
    protected static final String DEFAULT_CONFIG_PATH = "server.conf";
    private static final int PUBLISH_STATUS_SECONDS = 3;
    protected final PeerProfile peerProfile;
    private final IConfigurationReader configReader;
    private final IProcessManager processManager;
    private WampRouter router;
    private SimpleWampWebsocketListener server;
    protected WampClient serverClient;
    private FeedbackServiceMonitor feedbackServiceMonitor;
    private PeerStatusThread statusThread;
    private boolean fbsIsUsed = true;
    private StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            SuperPeer.this.serverClient.publish("http://vicci.eu/processes/statechange", new Object[]{arg});
        }
    };
    private HumanTaskRequestListener humanTaskRequestListener = new HumanTaskRequestListener(){

        public void onMessage(IHumanTaskRequest arg) {
            SuperPeer.this.serverClient.publish("http://vicci.eu/processes/humantaskreq", new Object[]{arg});
        }
    };
    private ProcessEngineListener processEngineListener = new ProcessEngineListener(){

        public void onProcessInstanceDeployed(IProcessInstanceInfo processInstanceInfo) {
            SuperPeer.this.publishEngineUpdate(IProcessEngineUpdate.UpdateType.INSTANCE_DEPLOYED, processInstanceInfo);
        }

        public void onProcessDeployed(IProcessInfo processInfo) {
            SuperPeer.this.publishEngineUpdate(IProcessEngineUpdate.UpdateType.PROCESS_DEPLOYED, processInfo);
        }
    };
    private HumanTaskResponseListener humanTaskResponseListener = new HumanTaskResponseListener(){

        public void onMessage(IHumanTaskResponse arg) {
            HumanTaskMessageManager.getInstance().addHumanTaskResponse(arg);
        }
    };
    private ClientBuilderFactory clientBuilderFactory = new ClientBuilderFactory(){

        public AbstractClientBuilder createClientBuilder() {
            return new ProcessEngineClientBuilder();
        }
    };
    private SuperPeerRequest superPeerRequest;

    public SuperPeer(IProcessManager processManager, IConfigurationReader configReader) {
        if (configReader == null || processManager == null) {
            throw new IllegalArgumentException("args cant be null");
        }
        this.configReader = configReader;
        this.processManager = processManager;
        this.processManager.addStateChangeListener(this.stateChangeListener);
        this.processManager.addHumanTaskRequestListener(this.humanTaskRequestListener);
        this.processManager.addProcessEngineListener(this.processEngineListener);
        this.processManager.setClientBuilderFactory(this.clientBuilderFactory);
        this.peerProfile = this.createPeerProfile();
    }

    public SuperPeer(IProcessManager processManager) {
        this(processManager, (IConfigurationReader)new ConfigurationReader(DEFAULT_CONFIG_PATH));
    }

    protected PeerProfile createPeerProfile() {
        PeerProfile profile = PeerProfile.create((boolean)true);
        this.addBaseInfosToPeerProfile(profile);
        return profile;
    }

    protected void addBaseInfosToPeerProfile(PeerProfile profile) {
        profile.setIp(this.getIpSafe());
        profile.setDevices(this.configReader.getDevices());
    }

    public void stop() {
        this.statusThread.stop();
        this.processManager.removeStateChangeListener(this.stateChangeListener);
        this.processManager.removeHumanTaskRequestListener(this.humanTaskRequestListener);
        this.processManager.removeProcessEngineListener(this.processEngineListener);
        this.serverClient.close().toBlocking().last();
        this.stopRouter();
    }

    protected void stopRouter() {
        this.server.stop();
        this.router.close().toBlocking().last();
    }

    public void start() throws ApplicationError {
        this.startWampRouterAndClient(this.configReader);
        this.operationsAfterConnection();
        this.serverClient.open();
        this.statusThread = new PeerStatusThread(3);
        this.statusThread.start();
    }

    private void operationsAfterConnection() {
        this.serverClient.statusChanged().subscribe(state -> {
            if (!(state instanceof WampClient.ConnectedState)) {
                return;
            }
            this.registerRpcHandlers();
            this.subscripeToTopics();
            this.registerPeer();
        });
    }

    public PeerProfile getPeerProfile() {
        return this.peerProfile;
    }

    protected void registerPeer() {
    }

    private void publishEngineUpdate(IProcessEngineUpdate.UpdateType type, Object payload) {
        String payloadStr = null;
        try {
            payloadStr = new ObjectMapper().writeValueAsString(payload);
        }
        catch (JsonProcessingException e) {
            e.printStackTrace();
        }
        ProcessEngineUpdate update = new ProcessEngineUpdate(type, payloadStr);
        this.serverClient.publish("http://vicci.eu/processes/engine/update", new Object[]{update});
    }

    private void subscripeToTopics() {
        this.serverClient.makeSubscription("http://vicci.eu/processes/humantaskresp").subscribe((Subscriber)new HumanTaskResponseSubscriber(this.humanTaskResponseListener));
    }

    private void startWampRouterAndClient(IConfigurationReader configReader) throws ApplicationError {
        String port = configReader.getPort();
        String namespace = configReader.getNamespace();
        String realmName = configReader.getRealmName();
        this.startRouter(port, namespace, realmName);
        this.startClient(port, namespace, realmName);
    }

    protected void startClient(String ip, String port, String namespace, String realmName) throws ApplicationError {
        NettyWampClientConnectorProvider connectorProvider = new NettyWampClientConnectorProvider();
        WampClientBuilder builder = new WampClientBuilder();
        builder.withConnectorProvider((IWampConnectorProvider)connectorProvider).withUri("ws://" + ip + ":" + port + "/" + namespace).withRealm(realmName).withInfiniteReconnects().withReconnectInterval(3, TimeUnit.SECONDS).withConnectionConfiguration((IWampClientConnectionConfig)this.getNettyWampConfig());
        try {
            this.serverClient = builder.build();
        }
        catch (Exception e) {
            throw new ApplicationError(e.getMessage());
        }
    }

    protected void startClient(String port, String namespace, String realmName) throws ApplicationError {
        this.startClient("localhost", port, namespace, realmName);
    }

    private NettyWampConnectionConfig getNettyWampConfig() {
        return new NettyWampConnectionConfig.Builder().withMaxFramePayloadLength(0x1000000).build();
    }

    protected void startRouter(String port, String namespace, String realmName) throws ApplicationError {
        WampRouterBuilder routerBuilder = new WampRouterBuilder();
        routerBuilder.addRealm(realmName);
        this.router = routerBuilder.build();
        URI serverUri = URI.create("ws://0.0.0.0:" + port + "/" + namespace);
        this.server = new SimpleWampWebsocketListener(this.router, serverUri, null);
        this.server.start();
    }

    private void createSuperPeerRequest() {
        this.superPeerRequest = new SuperPeerRequest();
        this.superPeerRequest.profile = this.peerProfile;
        this.superPeerRequest.port = this.configReader.getPort();
        this.superPeerRequest.namespace = this.configReader.getNamespace();
        this.superPeerRequest.realm = this.configReader.getRealmName();
    }

    private void requestingFeedbackMonitor() {
        if (this instanceof Peer) {
            return;
        }
        if (this.feedbackServiceMonitor == null) {
            this.createFeedbackServiceMonitor();
        }
        if (this.superPeerRequest == null) {
            this.createSuperPeerRequest();
        }
        try {
            this.feedbackServiceMonitor.requestingMonitoring(this.superPeerRequest);
        }
        catch (NullPointerException e) {
            LOG.info("Feedback Service Client not initialized. SuperPeer will not request the FBS.");
        }
        catch (RetryableException e) {
            LOG.error("error while connecting feedback-service: {}", (Object)e.getMessage());
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    protected void registerRpcHandlers() {
        this.registerProcedure("http://vicci.eu/processes/listmodels", new ModelListServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/uploadmodel", new UploadModelServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/deploymodel", new DeployModelServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processinfos", new ProcessInfosServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processlist", new ProcessListServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processinstancelist", new ProcessInstanceListServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processinstanceinfos", new ProcessInstanceInfosServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/startinstance", new StartInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/stopinstance", new StopInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/pauseinstance", new PauseInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/resumeinstance", new ResumeInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processdoc", new ProcessDocumentServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/instanceconfiguration", new InstanceConfigurationServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/deployinstance", new DeployInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/deployprocess", new DeployProcessServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/removeinstance", new RemoveInstanceServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/processinstanceinfosreduced", new ProcessInstanceInfosReducedServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/instancelog", new RetrieveInstanceLogServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/instancestate", new RetrieveInstanceStateServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/recentstatechanges", new RetrieveRecentStateChangesServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/executeprocessstep", new ExecuteProcessStepServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/uploadanddeploy", new UploadAndDeployServerHandler(this.processManager));
        this.registerProcedure("http://vicci.eu/processes/registerclient", new RegisterClientServerHandler());
        this.registerProcedure("http://vicci.eu/processes/openhumantasklist", new RetrieveOpenHumanTaskRequestsHandler());
        this.registerProcedure("http://vicci.eu/processes/closedhumantaskresponselist", new RetrieveClosedHumanTaskResponses());
        this.registerProcedure("http://vicci.eu/semantic/persons", new SemanticPersonsHandler());
        this.registerProcedure("http://vicci.eu/processes/registeredPeers", new RetrieveRegisteredPeersListServerHandler());
        this.registerProcedure("http://vicci.eu/processes/registerPeer", new RegisterPeerServerHandler());
    }

    protected void registerProcedure(String rpcId, AbstractRpcHandler handler) {
        this.serverClient.registerProcedure(rpcId).subscribe((Subscriber)handler);
    }

    protected void createFeedbackServiceMonitor() {
        String feedbackHost = this.configReader.getFeedbackServiceUri();
        boolean bl = this.fbsIsUsed = feedbackHost != null && !feedbackHost.isEmpty();
        if (!this.fbsIsUsed) {
            return;
        }
        if (!feedbackHost.startsWith("http://")) {
            feedbackHost = "http://" + feedbackHost;
        }
        this.feedbackServiceMonitor = (FeedbackServiceMonitor)Feign.builder().encoder((Encoder)new JacksonEncoder()).target(FeedbackServiceMonitor.class, feedbackHost);
    }

    protected String getIpSafe() {
        String ip = Util.getLocalIpWithFilter();
        if (ip == null || ip.isEmpty()) {
            throw new RuntimeException("Cant find the ip of this host. Maybe check the ip filter in the config file.");
        }
        LOG.debug("Runtime exposes IP: {}", (Object)ip);
        return ip;
    }

    protected void publishPeerMetrics() {
        PeerMetrics metrics = new PeerMetrics();
        metrics.peerId = this.peerProfile.getPeerId();
        metrics.hasBattery = Util.systemHasBattery();
        metrics.batteryStatus = Util.getSystemBatteryStatus();
        if (this.serverClient != null) {
            this.serverClient.publish("http://vicci.eu/processes/peer/metrics", new Object[]{metrics});
        }
    }

    protected void publishPeerStatus() {
        if (this.fbsIsUsed) {
            this.requestingFeedbackMonitor();
        }
        this.publishPeerMetrics();
    }

    private class PeerStatusThread
    implements Runnable {
        private final int timeout;
        private boolean terminate = false;

        private PeerStatusThread(int seconds) {
            this.timeout = 1000 * seconds;
        }

        private void start() {
            Thread thread = new Thread(this);
            thread.setName(PeerStatusThread.class.getSimpleName());
            thread.setDaemon(true);
            thread.start();
        }

        @Override
        public void run() {
            while (!this.terminate) {
                SuperPeer.this.publishPeerStatus();
                try {
                    Thread.sleep(this.timeout);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
            }
        }

        private void stop() {
            this.terminate = true;
        }
    }
}

