/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.wampserver;

import eu.vicci.process.client.core.IConfigurationReader;
import eu.vicci.process.distribution.core.PeerProfile;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.util.ConfigurationReader;
import eu.vicci.process.wampserver.SuperPeer;
import eu.vicci.process.wampserver.handlers.AbstractRpcHandler;
import rx.Subscriber;
import ws.wamp.jawampa.ApplicationError;

public class Peer
extends SuperPeer {
    private final String superPeerIp;

    public Peer(IProcessManager processManager, String superPeerIp) {
        this(processManager, (IConfigurationReader)new ConfigurationReader("server.conf"), superPeerIp);
    }

    public Peer(IProcessManager processManager, IConfigurationReader configReader, String superPeerIp) {
        super(processManager, configReader);
        this.superPeerIp = superPeerIp;
    }

    @Override
    protected PeerProfile createPeerProfile() {
        PeerProfile profile = PeerProfile.create((boolean)false);
        this.addBaseInfosToPeerProfile(profile);
        return profile;
    }

    @Override
    protected void registerProcedure(String rpcId, AbstractRpcHandler handler) {
        this.serverClient.registerProcedure(rpcId + "_" + this.peerProfile.getPeerId()).subscribe((Subscriber)handler);
    }

    @Override
    protected void startClient(String port, String namespace, String realmName) throws ApplicationError {
        this.startClient(this.superPeerIp, port, namespace, realmName);
    }

    @Override
    protected void registerPeer() {
        this.serverClient.call("http://vicci.eu/processes/registerPeer", new Object[]{this.peerProfile}).subscribe();
    }

    @Override
    protected void stopRouter() {
    }

    @Override
    protected void startRouter(String port, String namespace, String realmName) throws ApplicationError {
    }

    @Override
    protected void publishPeerStatus() {
        this.publishPeerMetrics();
    }
}

