/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.util;

import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.server.util.Kernel32;
import eu.vicci.process.server.util.LinuxBattery;
import java.net.Inet4Address;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import org.apache.commons.lang3.SystemUtils;

public class Util {
    private static volatile boolean returnStaticBatteryLevel = false;
    private static volatile Integer staticBatteryLevel = 100;

    public static void returnStaticBatteryLevel(boolean returnStatic) {
        returnStaticBatteryLevel = returnStatic;
    }

    public static void setStaticBatteryLevel(Integer level) {
        staticBatteryLevel = level;
    }

    public static String getLocalIpWithFilter() {
        String filter = ConfigurationManager.getInstance().getConfigAsString("PROTEUS_IP_FILTER");
        String ip = null;
        try {
            ip = Util.loopIpAddresses(filter);
        }
        catch (SocketException | UnknownHostException e) {
            e.printStackTrace();
        }
        return ip;
    }

    public static Integer getSystemBatteryStatus() {
        if (returnStaticBatteryLevel) {
            return staticBatteryLevel;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return Util.getWindowsBattery();
        }
        if (SystemUtils.IS_OS_UNIX) {
            return Util.getUnixBattery();
        }
        if (SystemUtils.IS_OS_LINUX) {
            return Util.getLinuxBattery();
        }
        throw new RuntimeException("unsupported operating system");
    }

    public static boolean systemHasBattery() {
        if (returnStaticBatteryLevel) {
            return true;
        }
        if (SystemUtils.IS_OS_WINDOWS) {
            return Util.windowsHasBattery();
        }
        if (SystemUtils.IS_OS_LINUX) {
            return Util.linuxHasBattery();
        }
        if (SystemUtils.IS_OS_UNIX) {
            return Util.unixHasBattery();
        }
        throw new RuntimeException("unsupported operating system");
    }

    private static boolean windowsHasBattery() {
        Kernel32.SYSTEM_POWER_STATUS batteryStatus = new Kernel32.SYSTEM_POWER_STATUS();
        Kernel32.INSTANCE.GetSystemPowerStatus(batteryStatus);
        return batteryStatus.hasBattery();
    }

    private static boolean linuxHasBattery() {
        return new LinuxBattery().hasBattery();
    }

    private static boolean unixHasBattery() {
        return new LinuxBattery().hasBattery();
    }

    private static Integer getWindowsBattery() {
        Kernel32.SYSTEM_POWER_STATUS batteryStatus = new Kernel32.SYSTEM_POWER_STATUS();
        Kernel32.INSTANCE.GetSystemPowerStatus(batteryStatus);
        if (!batteryStatus.hasBattery()) {
            return null;
        }
        return new Integer(batteryStatus.getBatteryLifePercentInt());
    }

    private static Integer getLinuxBattery() {
        return new LinuxBattery().getBatteryLevel();
    }

    private static Integer getUnixBattery() {
        return new LinuxBattery().getBatteryLevel();
    }

    private static String loopIpAddresses(String filter) throws UnknownHostException, SocketException {
        if (filter == null || filter.isEmpty()) {
            return Inet4Address.getLocalHost().getHostAddress();
        }
        Enumeration<NetworkInterface> e = NetworkInterface.getNetworkInterfaces();
        while (e.hasMoreElements()) {
            NetworkInterface n = e.nextElement();
            Enumeration<InetAddress> ee = n.getInetAddresses();
            while (ee.hasMoreElements()) {
                InetAddress i = ee.nextElement();
                String candidate = i.getHostAddress();
                if (!candidate.startsWith(filter)) continue;
                return candidate;
            }
        }
        return null;
    }
}

