/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.util;

import eu.vicci.process.engine.core.IProcessManager;
import java.util.HashMap;
import java.util.Map;

public class RuntimeContext {
    private Map<String, Object> services = new HashMap<String, Object>();
    public static final String PROCESS_MANAGER = "processmanager";

    public static RuntimeContext getInstance() {
        return LazyHolder.INSTANCE;
    }

    public void registerProcessManager(IProcessManager processManager) {
        this.putSafe(PROCESS_MANAGER, processManager);
    }

    public IProcessManager getProcessManager() {
        return this.getSafe(PROCESS_MANAGER, IProcessManager.class);
    }

    private <T> T getSafe(String id, Class<T> clazz) {
        if (!this.services.containsKey(id)) {
            throw new IllegalStateException(id + " was not registered in RuntimeContext");
        }
        return (T)this.services.get(id);
    }

    private void putSafe(String id, Object service) {
        if (service == null) {
            throw new IllegalArgumentException("registered service cant be null for " + id);
        }
        this.services.put(id, service);
    }

    private static class LazyHolder {
        private static final RuntimeContext INSTANCE = new RuntimeContext();

        private LazyHolder() {
        }
    }
}

