/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.util;

import java.io.BufferedReader;
import java.io.File;
import java.io.InputStreamReader;

public class LinuxBattery {
    private static final String BAT_PATH = "/sys/class/power_supply";
    private static final String BAT_NAME = "BAT";
    private static final String BAT_CAP = "capacity";
    private File file = new File("/sys/class/power_supply");

    public boolean hasBattery() {
        if (!this.file.exists()) {
            return false;
        }
        return this.findFirstBat() != null;
    }

    public Integer getBatteryLevel() {
        if (!this.file.exists()) {
            return null;
        }
        String firstBat = this.findFirstBat();
        if (firstBat == null) {
            return null;
        }
        String cmd = "cat /sys/class/power_supply/" + firstBat + "/" + BAT_CAP;
        Integer out = null;
        try {
            Process proc = Runtime.getRuntime().exec(cmd);
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(proc.getInputStream()));
            String value = stdInput.readLine();
            out = Integer.parseInt(value);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return out;
    }

    private String findFirstBat() {
        File[] files = this.file.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (!files[i].getName().startsWith(BAT_NAME)) continue;
            return files[i].getName();
        }
        return null;
    }
}

