/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.util;

import com.sun.jna.Native;
import com.sun.jna.Structure;
import com.sun.jna.win32.StdCallLibrary;
import java.util.ArrayList;
import java.util.List;

public interface Kernel32
extends StdCallLibrary {
    public static final Kernel32 INSTANCE = (Kernel32)Native.loadLibrary((String)"Kernel32", Kernel32.class);

    public int GetSystemPowerStatus(SYSTEM_POWER_STATUS var1);

    public static class SYSTEM_POWER_STATUS
    extends Structure {
        public byte ACLineStatus;
        public byte BatteryFlag;
        public byte BatteryLifePercent;
        public byte Reserved1;
        public int BatteryLifeTime;
        public int BatteryFullLifeTime;

        protected List<String> getFieldOrder() {
            ArrayList<String> fields = new ArrayList<String>();
            fields.add("ACLineStatus");
            fields.add("BatteryFlag");
            fields.add("BatteryLifePercent");
            fields.add("Reserved1");
            fields.add("BatteryLifeTime");
            fields.add("BatteryFullLifeTime");
            return fields;
        }

        public String getACLineStatusString() {
            switch (this.ACLineStatus) {
                case 0: {
                    return "Offline";
                }
                case 1: {
                    return "Online";
                }
            }
            return "Unknown";
        }

        public String getBatteryFlagString() {
            switch (this.BatteryFlag) {
                case 1: {
                    return "High, more than 66 percent";
                }
                case 2: {
                    return "Low, less than 33 percent";
                }
                case 4: {
                    return "Critical, less than five percent";
                }
                case 8: {
                    return "Charging";
                }
                case -128: {
                    return "No system battery";
                }
            }
            return "Unknown";
        }

        public int getBatteryLifePercentInt() {
            return this.BatteryLifePercent;
        }

        public boolean hasBattery() {
            return this.BatteryFlag != -128;
        }

        public String getBatteryLifePercent() {
            return this.BatteryLifePercent == -1 ? "Unknown" : this.BatteryLifePercent + "%";
        }

        public String getBatteryLifeTime() {
            return this.BatteryLifeTime == -1 ? "Unknown" : this.BatteryLifeTime + " seconds";
        }

        public String getBatteryFullLifeTime() {
            return this.BatteryFullLifeTime == -1 ? "Unknown" : this.BatteryFullLifeTime + " seconds";
        }

        public String toString() {
            StringBuilder sb = new StringBuilder();
            sb.append("ACLineStatus: " + this.getACLineStatusString() + "\n");
            sb.append("Battery Flag: " + this.getBatteryFlagString() + "\n");
            sb.append("Battery Life: " + this.getBatteryLifePercent() + "\n");
            sb.append("Battery Left: " + this.getBatteryLifeTime() + "\n");
            sb.append("Battery Full: " + this.getBatteryFullLifeTime() + "\n");
            return sb.toString();
        }
    }
}

