/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.rest;

import eu.vicci.process.client.core.UploadAndDeployRequest;
import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofia.SofiaPackage;
import eu.vicci.process.server.exception.BadRequestException;
import eu.vicci.process.server.exception.NotFoundErrorException;
import eu.vicci.process.server.exception.ServerErrorException;
import eu.vicci.process.server.util.RuntimeContext;
import io.swagger.annotations.Api;
import io.swagger.annotations.ApiOperation;
import io.swagger.annotations.ApiParam;
import io.swagger.annotations.ApiResponse;
import io.swagger.annotations.ApiResponses;
import java.io.InputStream;
import java.util.List;
import java.util.Map;
import javax.ws.rs.Consumes;
import javax.ws.rs.GET;
import javax.ws.rs.POST;
import javax.ws.rs.PUT;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.Response;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.resource.ResourceSet;
import org.eclipse.emf.ecore.resource.URIConverter;
import org.eclipse.emf.ecore.resource.impl.ResourceSetImpl;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Path(value="processes")
@Api(tags={"processes"})
public class ProcessManagerRest {
    private static final Logger LOG = LoggerFactory.getLogger(ProcessManagerRest.class);
    private final IProcessManager processManager;

    public ProcessManagerRest() {
        ProcessManagerRest.registerResourceFactories();
        this.processManager = RuntimeContext.getInstance().getProcessManager();
    }

    public IProcessManager getProcessManager() {
        return this.processManager;
    }

    @GET
    @Produces(value={"application/json"})
    @ApiOperation(value="Lists all deployed process instances, which available for deploying a process instance.", response=IProcessInfo.class, responseContainer="List")
    public List<IProcessInfo> deployedProcesses() {
        return this.processManager.listDeployedProcesses();
    }

    @PUT
    @Produces(value={"text/plain"})
    @Consumes(value={"application/json"})
    @ApiOperation(value="Uploads a process definition, which is saved to file on server. The process is then deployed to the engine and available for deploying as process instance.", notes="Returns the process id as string for the deployed process", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Process updaded."), @ApiResponse(code=201, message="Process uploaded and deployed."), @ApiResponse(code=400, message="Request contains errors or missing values."), @ApiResponse(code=500, message="Upload and deployment failed on server. Be sure the model is consistent.")})
    public Response uploadAndDeploy(@ApiParam(value="The request for uploading and deploying processes. The setting 'overrideExisting' will not update the model on the server properly at the moment. Set it to 'true' Restart the engine if you want to update the model. 'processdocument' should contain the process model (*.diagram file) as string. Restart the engine if you want to update the model.", required=true) UploadAndDeployRequest request) throws BadRequestException, ServerErrorException {
        if (request == null || ProcessManagerRest.isNullOrEmpty(request.getProcessdocument())) {
            throw new BadRequestException("Missing or empty process document.");
        }
        Process process = null;
        try {
            process = this.getProcessFromString(request.getProcessdocument());
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
            throw new ServerErrorException(e.getMessage());
        }
        if (process == null) {
            throw new ServerErrorException("Process could not be created.");
        }
        Process tmpProcess = this.processManager.getProcessInfos(process.getId());
        if (tmpProcess != null && !request.isOverrideExisting()) {
            throw new BadRequestException("The process with the id '%s' is already deployed in the engine. Change flag 'overrideExisiting' to true, to override the existing process.", process.getId());
        }
        String processId = this.processManager.uploadAndDeploy(process);
        if (processId == null) {
            throw new ServerErrorException("Process could not be deployed.");
        }
        return Response.status((Response.Status)(request.isOverrideExisting() ? Response.Status.OK : Response.Status.CREATED)).entity((Object)processId).type("text/plain").build();
    }

    @POST
    @Path(value="{processId}")
    @Produces(value={"text/plain"})
    @ApiOperation(value="Deploys a process instance for the given process id. This instance can then be used for execution.", notes="Returns the instance id as string of the deployed process", response=String.class)
    @ApiResponses(value={@ApiResponse(code=200, message="Process instance was created."), @ApiResponse(code=400, message="Request contains errors or missing values."), @ApiResponse(code=404, message="The process with the given process id does not exist on the server."), @ApiResponse(code=500, message="Upload and deployment failed on server. Be sure the model is consistent.")})
    public String deployProcessInstance(@ApiParam(value="The process id for the process which should be deployed as instance.", required=true) @PathParam(value="processId") String processId) throws BadRequestException, NotFoundErrorException, ServerErrorException {
        if (ProcessManagerRest.isNullOrEmpty(processId)) {
            throw new BadRequestException("Missing process id.");
        }
        Process process = this.processManager.getProcessInfos(processId);
        if (process == null) {
            throw new NotFoundErrorException("Process with id '%s' could not be found.", processId);
        }
        String instanceId = this.processManager.deployProcessInstance(processId);
        if (instanceId == null) {
            throw new ServerErrorException("Instance could not deployed for '%s'.", processId);
        }
        return instanceId;
    }

    private static boolean isNullOrEmpty(String value) {
        if (value == null) {
            return true;
        }
        return value.isEmpty();
    }

    private static void registerResourceFactories() {
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("diagram", new XMIResourceFactoryImpl());
        m.put("sofia", new XMIResourceFactoryImpl());
        m.put("sofiainstance", new XMIResourceFactoryImpl());
    }

    private Process getProcessFromString(String input) throws Exception {
        ResourceSet resSet = this.getConfiguredResourceSet();
        Resource resource = resSet.createResource(URI.createURI((String)"*.sofia"));
        resource.load((InputStream)new URIConverter.ReadableInputStream(input), resSet.getLoadOptions());
        EObject p = (EObject)resource.getContents().get(0);
        if (p instanceof Process) {
            return (Process)p;
        }
        p = (EObject)resource.getContents().get(1);
        return (Process)p;
    }

    private ResourceSet getConfiguredResourceSet() {
        ResourceSetImpl resSet = new ResourceSetImpl();
        resSet.getPackageRegistry().put((Object)SofiaPackage.eINSTANCE.getNsURI(), (Object)SofiaPackage.eINSTANCE);
        resSet.getResourceFactoryRegistry().getExtensionToFactoryMap().put("*", new XMIResourceFactoryImpl());
        resSet.getLoadOptions().put("RECORD_UNKNOWN_FEATURE", Boolean.TRUE);
        return resSet;
    }
}

