/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.http;

import com.fasterxml.jackson.jaxrs.json.JacksonJsonProvider;
import eu.vicci.process.server.events.StateChangesSse;
import eu.vicci.process.server.exception.BadRequestException;
import eu.vicci.process.server.rest.ProcessManagerRest;
import io.swagger.jaxrs.listing.ApiListingResource;
import io.swagger.jaxrs.listing.SwaggerSerializers;
import javax.servlet.Servlet;
import org.eclipse.jetty.server.Handler;
import org.eclipse.jetty.server.HandlerContainer;
import org.eclipse.jetty.server.Server;
import org.eclipse.jetty.server.handler.HandlerList;
import org.eclipse.jetty.server.handler.ResourceHandler;
import org.eclipse.jetty.servlet.ServletContextHandler;
import org.eclipse.jetty.servlet.ServletHolder;
import org.eclipse.jetty.util.resource.Resource;
import org.glassfish.jersey.jackson.JacksonFeature;
import org.glassfish.jersey.server.ResourceConfig;
import org.glassfish.jersey.servlet.ServletContainer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ProteusHttpServer
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(ProteusHttpServer.class);
    public static final String REST_BASE_PATH = "/rest";
    private static final String REST_PATH = "/rest/*";
    private static final String SSE_PATH = "/events/*";
    private static final String HTTP_CTX_PATH = "/";
    private static final String SWAGGER_PATH = "/api/*";
    private final int httpPort;
    private final Server server;

    public ProteusHttpServer(int httpPort) {
        this.server = new Server(httpPort);
        this.httpPort = httpPort;
        Handler http = this.getHttpHandler();
        Handler servlets = this.getServletsHandler();
        HandlerList handlers = new HandlerList();
        handlers.setHandlers(new Handler[]{http, servlets});
        this.server.setHandler((Handler)handlers);
    }

    private Handler getServletsHandler() {
        ServletContextHandler restHandler = new ServletContextHandler((HandlerContainer)this.server, HTTP_CTX_PATH);
        restHandler.addServlet(this.getRestServlet(), REST_PATH);
        restHandler.addServlet(this.getSseServlet(), SSE_PATH);
        restHandler.addServlet(this.getSwaggerServlet(), SWAGGER_PATH);
        return restHandler;
    }

    private ServletHolder getRestServlet() {
        ResourceConfig restConfig = new ResourceConfig();
        restConfig.register(JacksonJsonProvider.class);
        restConfig.register(JacksonFeature.class);
        restConfig.packages(new String[]{ProcessManagerRest.class.getPackage().getName()});
        restConfig.packages(new String[]{BadRequestException.class.getPackage().getName()});
        ServletHolder restServlet = new ServletHolder((Servlet)new ServletContainer(restConfig));
        return restServlet;
    }

    private ServletHolder getSseServlet() {
        ResourceConfig sseConfig = new ResourceConfig();
        sseConfig.packages(new String[]{StateChangesSse.class.getPackage().getName()});
        sseConfig.packages(new String[]{BadRequestException.class.getPackage().getName()});
        ServletHolder sseServlet = new ServletHolder((Servlet)new ServletContainer(sseConfig));
        return sseServlet;
    }

    private Handler getHttpHandler() {
        ResourceHandler httpHandler = new ResourceHandler();
        httpHandler.setBaseResource(Resource.newClassPathResource((String)"web"));
        httpHandler.setWelcomeFiles(new String[]{"index.html"});
        return httpHandler;
    }

    private ServletHolder getSwaggerServlet() {
        ResourceConfig resConfig = new ResourceConfig();
        resConfig.register(JacksonJsonProvider.class);
        resConfig.register(JacksonFeature.class);
        resConfig.packages(new String[]{ProcessManagerRest.class.getPackage().getName()});
        resConfig.packages(new String[]{ApiListingResource.class.getPackage().getName()});
        resConfig.packages(new String[]{SwaggerSerializers.class.getPackage().getName()});
        return new ServletHolder((Servlet)new ServletContainer(resConfig));
    }

    private void start() {
        LOG.debug("starting proteus http server on port '{}'...", (Object)this.httpPort);
        try {
            this.server.start();
            this.server.join();
        }
        catch (Exception ex) {
            LOG.error(ex.getMessage());
        }
        finally {
            this.server.destroy();
        }
    }

    public void stop() {
        try {
            this.server.stop();
        }
        catch (Exception e) {
            LOG.error(e.getMessage());
        }
        finally {
            this.server.destroy();
        }
    }

    @Override
    public void run() {
        this.start();
    }
}

