/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.events;

import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.messages.core.StateChangeListener;
import eu.vicci.process.server.events.StateChangeEventOutput;
import eu.vicci.process.server.exception.NotFoundErrorException;
import eu.vicci.process.server.util.RuntimeContext;
import java.io.IOException;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.PathParam;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="statechanges")
public class StateChangesSse {
    private final IProcessManager processManager;
    private final SseBroadcaster broadcaster;
    private final StateChangeListener stateChangeListener = new StateChangeListener(){

        public void onMessage(IStateChangeMessage arg) {
            StateChangesSse.this.broadcaster.broadcast((Object)new OutboundEvent.Builder().mediaType(MediaType.APPLICATION_JSON_TYPE).data((Object)arg).build());
        }
    };

    public StateChangesSse() {
        this.processManager = RuntimeContext.getInstance().getProcessManager();
        this.broadcaster = new SseBroadcaster();
        this.processManager.addStateChangeListener(this.stateChangeListener);
    }

    @GET
    @Path(value="{processInstanceId}")
    @Produces(value={"text/event-stream"})
    public EventOutput getStateChangesForInstance(@PathParam(value="processInstanceId") String processInstanceId) throws NotFoundErrorException, IOException {
        StateChangeEventOutput event = new StateChangeEventOutput(processInstanceId);
        this.broadcaster.add((ChunkedOutput)event);
        return event;
    }

    @GET
    @Produces(value={"text/event-stream"})
    public EventOutput getAllStateChanges() throws NotFoundErrorException, IOException {
        StateChangeEventOutput event = new StateChangeEventOutput();
        this.broadcaster.add((ChunkedOutput)event);
        return event;
    }
}

