/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.server.events;

import eu.vicci.process.engine.core.IProcessInfo;
import eu.vicci.process.engine.core.IProcessInstanceInfo;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.util.messages.core.ProcessEngineListener;
import eu.vicci.process.server.util.RuntimeContext;
import javax.ws.rs.GET;
import javax.ws.rs.Path;
import javax.ws.rs.Produces;
import javax.ws.rs.core.MediaType;
import org.glassfish.jersey.media.sse.EventOutput;
import org.glassfish.jersey.media.sse.OutboundEvent;
import org.glassfish.jersey.media.sse.SseBroadcaster;
import org.glassfish.jersey.server.ChunkedOutput;

@Path(value="engineupdates")
public class ProcessEngineUpdatesSse {
    private final IProcessManager processManager;
    private final SseBroadcaster broadcaster;
    private final ProcessEngineListener engineListener = new ProcessEngineListener(){

        public void onProcessInstanceDeployed(IProcessInstanceInfo processInstanceInfo) {
            ProcessEngineUpdatesSse.this.broadcast(processInstanceInfo);
        }

        public void onProcessDeployed(IProcessInfo processInfo) {
            ProcessEngineUpdatesSse.this.broadcast(processInfo);
        }
    };

    public ProcessEngineUpdatesSse() {
        this.processManager = RuntimeContext.getInstance().getProcessManager();
        this.broadcaster = new SseBroadcaster();
        this.processManager.addProcessEngineListener(this.engineListener);
    }

    @GET
    @Produces(value={"text/event-stream"})
    public EventOutput getEngineUpdates() {
        EventOutput output = new EventOutput();
        this.broadcaster.add((ChunkedOutput)output);
        return output;
    }

    private void broadcast(Object object) {
        this.broadcaster.broadcast((Object)new OutboundEvent.Builder().data(object).mediaType(MediaType.APPLICATION_JSON_TYPE).build());
    }
}

