/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.runtime;

import com.fasterxml.jackson.core.Version;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectReader;
import eu.vicci.process.client.core.IConfigurationReader;
import eu.vicci.process.devices.util.OpenHabListener;
import eu.vicci.process.distribution.manager.DistributionManager;
import eu.vicci.process.engine.ProcessManagerPublic;
import eu.vicci.process.engine.core.IProcessManager;
import eu.vicci.process.model.cep.EsperEngine;
import eu.vicci.process.model.sofia.SofiaPackage;
import eu.vicci.process.model.sofiainstance.SofiaInstancePackage;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import eu.vicci.process.model.util.ConfigurationReader;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import eu.vicci.process.osgi.OSGiRuntime;
import eu.vicci.process.server.http.ProteusHttpServer;
import eu.vicci.process.server.util.RuntimeContext;
import eu.vicci.process.wampserver.Peer;
import eu.vicci.process.wampserver.SuperPeer;
import java.io.File;
import java.util.Map;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.emf.ecore.xmi.impl.XMIResourceFactoryImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ws.wamp.jawampa.ApplicationError;

public class VicciRuntime {
    private static final Logger LOG = LoggerFactory.getLogger(VicciRuntime.class);
    private static final String PATH_MODEL = "processes/models/";
    private SuperPeer server;
    private IProcessManager processManagerPublic = new ProcessManagerPublic();
    private boolean readConfigFromEnv = false;
    private ProteusHttpServer httpServer;

    public static void main(String[] args) {
        boolean started;
        Options options = VicciRuntime.prepareOptions();
        CommandLine cmd = VicciRuntime.parseArguments(args, options);
        if (cmd == null) {
            return;
        }
        if (cmd.hasOption("help")) {
            HelpFormatter help = new HelpFormatter();
            help.printHelp("vicci-runtime", options);
            return;
        }
        LOG.info("starting vicci runtime...");
        VicciRuntime runtime = new VicciRuntime();
        if (cmd.hasOption("container")) {
            runtime.readConfigFromEnv = true;
        }
        if (!(started = runtime.start())) {
            LOG.error("failed to start vicci runtime");
            return;
        }
        ObjectMapper m = new ObjectMapper();
        ObjectReader reader = m.reader();
        Version version = reader.version();
        LOG.info("Jackson Version:\n{}", (Object)version.toString());
        LOG.info("vicci runtime started as {}", (Object)runtime.getRuntimeType());
    }

    private static CommandLine parseArguments(String[] args, Options options) {
        DefaultParser parser = new DefaultParser();
        try {
            return parser.parse(options, args);
        }
        catch (ParseException e) {
            LOG.error(e.getLocalizedMessage());
            return null;
        }
    }

    private static Options prepareOptions() {
        Option optionContainer = Option.builder((String)"container").desc("To tell proteus, it is running in a container. PROtEUS will try to get all config values from the environment.").build();
        Option optionHelp = Option.builder((String)"help").desc("Show this help.").build();
        Options options = new Options();
        options.addOption(optionHelp);
        options.addOption(optionContainer);
        return options;
    }

    public VicciRuntime() {
        RuntimeContext.getInstance().registerProcessManager(this.processManagerPublic);
    }

    public boolean start() {
        ConfigurationReader configReader = this.readConfigFromEnv ? new ConfigurationReader() : new ConfigurationReader("server.conf");
        ConfigurationManager.getInstance().updateFromConfigReader((IConfigurationReader)configReader);
        if (!configReader.deployExistingProcessModels()) {
            this.deleteExistingModels();
        }
        VicciRuntime.initializeSofiaModel();
        this.registerListener((IConfigurationReader)configReader);
        boolean isWebSocketServerStarted = this.startWebSocketServer((IConfigurationReader)configReader);
        this.startHttpServer((IConfigurationReader)configReader);
        DistributionManager.getInstance().setPeerProfile(this.server.getPeerProfile());
        LifeCycleManager.INSTANCE.getClass();
        return isWebSocketServerStarted;
    }

    private String getRuntimeType() {
        return this.server.getClass().getSimpleName();
    }

    public void stop() {
        this.server.stop();
    }

    private static void initializeSofiaModel() {
        SofiaPackage.eINSTANCE.eClass();
        SofiaInstancePackage.eINSTANCE.eClass();
        Resource.Factory.Registry reg = Resource.Factory.Registry.INSTANCE;
        Map m = reg.getExtensionToFactoryMap();
        m.put("diagram", new XMIResourceFactoryImpl());
        m.put("sofia", new XMIResourceFactoryImpl());
        m.put("sofiainstance", new SofiaInstanceFactoryImplCustom());
        m.put("sofiainstance", new XMIResourceFactoryImpl());
    }

    private void registerListener(IConfigurationReader configReader) {
        if (configReader.startOsgiRuntime()) {
            OSGiRuntime.getInstance().start();
        }
        if (configReader.startOpenHabListener()) {
            OpenHabListener.getInstance().start();
        }
        if (configReader.startCepEngine()) {
            EsperEngine.getInstance();
        }
        if (configReader.deployExistingProcessModels()) {
            this.processManagerPublic.loadExistingModels();
        }
    }

    private boolean startWebSocketServer(IConfigurationReader configReader) {
        try {
            this.server = configReader.getSuperPeerIp() == null ? new SuperPeer(this.processManagerPublic, configReader) : new Peer(this.processManagerPublic, configReader, configReader.getSuperPeerIp());
            this.server.start();
            return true;
        }
        catch (ApplicationError e) {
            e.printStackTrace();
            return false;
        }
    }

    private void startHttpServer(IConfigurationReader configReader) {
        this.httpServer = new ProteusHttpServer(configReader.getHttpPort());
        Thread t = new Thread(this.httpServer);
        t.setName("ProteusHttpServerThread");
        t.setDaemon(true);
        t.start();
    }

    private void deleteExistingModels() {
        File file = new File(PATH_MODEL);
        if (!file.exists()) {
            return;
        }
        for (File tmpFile : file.listFiles()) {
            if (!tmpFile.isFile()) continue;
            tmpFile.delete();
        }
    }
}

