/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.openhab.util;

import eu.vicci.process.devices.util.OpenHabEvent;
import java.net.URI;
import java.util.ArrayList;
import java.util.List;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.client.WebTarget;
import javax.ws.rs.core.UriBuilder;
import org.glassfish.jersey.media.sse.EventListener;
import org.glassfish.jersey.media.sse.EventSource;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabEventProvider {
    private static final Logger logger = LoggerFactory.getLogger(OpenHabEventProvider.class);
    public static final String EVENTS_PATH = "/rest/events";
    private List<EventSource> eventSources = new ArrayList<EventSource>();
    private final String serverBasePath;
    private Client client;

    public OpenHabEventProvider(String serverBasePath) {
        this.serverBasePath = serverBasePath;
        this.client = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
    }

    public void registerToItemState(final OHEventItemStateListener listener) {
        this.register(new EventListener(){

            public void onEvent(InboundEvent arg0) {
                listener.onItemState((OpenHabEvent.OHItemStateEvent)OpenHabEventProvider.ohEventFromInbound(arg0, OpenHabEvent.OHItemStateEvent.class));
            }
        }, "smarthome/items/*/state");
    }

    public void registerToItemAdded(final OHEventItemAddedListener listener) {
        this.register(new EventListener(){

            public void onEvent(InboundEvent arg0) {
                listener.onItemAdded((OpenHabEvent.OHItemAddedEvent)OpenHabEventProvider.ohEventFromInbound(arg0, OpenHabEvent.OHItemAddedEvent.class));
            }
        }, "smarthome/items/*/added");
    }

    public void registerToItemRemoved(final OHEventItemRemovedListener listener) {
        this.register(new EventListener(){

            public void onEvent(InboundEvent arg0) {
                listener.onItemRemoved((OpenHabEvent.OHItemRemovedEvent)OpenHabEventProvider.ohEventFromInbound(arg0, OpenHabEvent.OHItemRemovedEvent.class));
            }
        }, "smarthome/items/*/removed");
    }

    public void registerToItemUpdated(final OHEventItemUpdatedListener listener) {
        this.register(new EventListener(){

            public void onEvent(InboundEvent arg0) {
                listener.onItemUpdated((OpenHabEvent.OHItemUpdatedEvent)OpenHabEventProvider.ohEventFromInbound(arg0, OpenHabEvent.OHItemUpdatedEvent.class));
            }
        }, "smarthome/items/*/updated");
    }

    private void register(EventListener listener, String path) {
        String eventName = this.getEventNameWithoutLastSlash(path);
        URI uri = UriBuilder.fromPath((String)this.serverBasePath).path(EVENTS_PATH).queryParam("topics", new Object[]{eventName}).build(new Object[0]);
        logger.debug("register to events on uri: {}", (Object)uri.toString());
        this.registerTo(uri, listener);
    }

    public void registerToAllEvents(EventListener listener) {
        URI uri = UriBuilder.fromPath((String)this.serverBasePath).path(EVENTS_PATH).build(new Object[0]);
        logger.debug("register to events on uri: {}", (Object)uri.toString());
        this.registerTo(uri, listener);
    }

    public void closeAllEventSources() {
        for (EventSource eventSource : this.eventSources) {
            if (!eventSource.isOpen()) continue;
            eventSource.close();
        }
        this.eventSources.clear();
    }

    private void registerTo(URI uri, EventListener listener) {
        WebTarget target = this.client.target(uri);
        EventSource eventSource = new EventSource(target, false){

            public void onEvent(InboundEvent inboundEvent) {
            }
        };
        eventSource.register(listener);
        eventSource.open();
        this.eventSources.add(eventSource);
    }

    private String getEventNameWithoutLastSlash(String eventName) {
        if (!eventName.endsWith("/")) {
            return eventName;
        }
        int tmp = eventName.lastIndexOf("/");
        return eventName.substring(0, tmp);
    }

    private static <T extends OpenHabEvent> T ohEventFromInbound(InboundEvent event, Class<T> clazz) {
        return OpenHabEvent.fromJson((String)event.readData(String.class), clazz);
    }

    public static interface OHEventItemUpdatedListener {
        public void onItemUpdated(OpenHabEvent.OHItemUpdatedEvent var1);
    }

    public static interface OHEventItemRemovedListener {
        public void onItemRemoved(OpenHabEvent.OHItemRemovedEvent var1);
    }

    public static interface OHEventItemAddedListener {
        public void onItemAdded(OpenHabEvent.OHItemAddedEvent var1);
    }

    public static interface OHEventItemStateListener {
        public void onItemState(OpenHabEvent.OHItemStateEvent var1);
    }
}

