/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import eu.vicci.process.devices.util.OpenHabEvent;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.OpenHabWaitForEvent;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import eu.vicci.process.openhab.util.OpenHabEventProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabWaitForEventWithResult
implements ProcessStepWorker,
OpenHabEventProvider.OHEventItemStateListener {
    private static final Logger logger = LoggerFactory.getLogger(OpenHabWaitForEvent.class);
    private static final String serverType = "StepServerBasePath";
    private static final String RESULT_TYPE = "OpenHabResult";
    private Map<String, DataTypeInstance> itemsToWaitFor;
    private DataTypeInstance resultInstance;
    private List<DataTypeInstance> returnValues;
    private String uriBasePath;
    private CountDownLatch eventSignal;

    @Override
    public void deploy() {
    }

    @Override
    public List<DataTypeInstance> work(ProcessStepWorker.Context context) {
        this.returnValues = new ArrayList<DataTypeInstance>();
        this.eventSignal = new CountDownLatch(1);
        this.setAllItemsToWaitForAndServerBasePath(context.startParameter);
        this.setResultParamter(context.startParameter);
        if (this.uriBasePath == null || this.uriBasePath.isEmpty()) {
            return this.returnValues;
        }
        OpenHabEventProvider provider = new OpenHabEventProvider(this.uriBasePath);
        provider.registerToItemState(this);
        try {
            this.eventSignal.await();
        }
        catch (InterruptedException e) {
            logger.error("waiting for events was interrupted");
            e.printStackTrace();
        }
        provider.closeAllEventSources();
        return this.returnValues;
    }

    @Override
    public void onItemState(OpenHabEvent.OHItemStateEvent ohEvent) {
        OpenHabEvent.OHItemStatePayload payload = (OpenHabEvent.OHItemStatePayload)ohEvent.getTypedPayload();
        String itemName = ohEvent.getItemName();
        if (!this.itemsToWaitFor.containsKey(itemName)) {
            return;
        }
        if (payload.getValue() == null || payload.getValue().isEmpty()) {
            return;
        }
        DataTypeInstance instance = this.itemsToWaitFor.get(itemName);
        instance.parse(payload.getValue());
        this.returnValues.add(instance);
        if (this.resultInstance != null) {
            this.resultInstance.parse(payload.getValue());
            this.returnValues.add(this.resultInstance);
        }
        this.eventSignal.countDown();
    }

    private void setAllItemsToWaitForAndServerBasePath(List<DataTypeInstance> parameter) {
        this.itemsToWaitFor = new HashMap<String, DataTypeInstance>();
        for (DataTypeInstance dataTypeInstance : parameter) {
            String name = dataTypeInstance.getDataTypeType().getName();
            if (serverType.equals(name)) {
                this.uriBasePath = (String)dataTypeInstance.getValueAsObject();
                continue;
            }
            this.itemsToWaitFor.put(name, dataTypeInstance);
        }
    }

    private void setResultParamter(List<DataTypeInstance> parameter) {
        Optional<DataTypeInstance> di = parameter.stream().filter(d -> RESULT_TYPE.equals(d.getDataTypeType().getName())).findFirst();
        this.resultInstance = di.isPresent() ? di.get() : null;
    }
}

