/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import eu.vicci.process.devices.util.OpenHabEvent;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import eu.vicci.process.openhab.util.OpenHabEventProvider;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Timer;
import java.util.TimerTask;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class OpenHabWaitForEvent
implements ProcessStepWorker,
OpenHabEventProvider.OHEventItemStateListener {
    private static final Logger logger = LoggerFactory.getLogger(OpenHabWaitForEvent.class);
    private static final String serverType = "StepServerBasePath";
    private static final String timeoutType = "StepTimeout";
    private Map<String, DataTypeInstance> itemsToWaitFor;
    private List<DataTypeInstance> returnValues;
    private List<DataTypeInstance> timeoutReturnList;
    private String uriBasePath;
    private CountDownLatch eventSignal;
    private boolean timeoutHappend = false;

    @Override
    public void deploy() {
    }

    @Override
    public List<DataTypeInstance> work(ProcessStepWorker.Context context) {
        this.returnValues = new ArrayList<DataTypeInstance>();
        this.eventSignal = new CountDownLatch(1);
        this.setAllItemsToWaitForAndServerBasePath(context.startParameter);
        if (this.uriBasePath == null || this.uriBasePath.isEmpty()) {
            return this.returnValues;
        }
        OpenHabEventProvider provider = new OpenHabEventProvider(this.uriBasePath);
        provider.registerToItemState(this);
        this.setTimeoutIfPresent(context.startParameter);
        try {
            this.eventSignal.await();
        }
        catch (InterruptedException e) {
            logger.error("waiting for events was interrupted");
            e.printStackTrace();
        }
        provider.closeAllEventSources();
        if (this.timeoutHappend) {
            return this.timeoutReturnList;
        }
        return this.returnValues;
    }

    @Override
    public synchronized void onItemState(OpenHabEvent.OHItemStateEvent ohEvent) {
        if (ohEvent == null) {
            logger.error("error while event processing");
            return;
        }
        OpenHabEvent.OHItemStatePayload payload = (OpenHabEvent.OHItemStatePayload)ohEvent.getTypedPayload();
        String itemName = ohEvent.getItemName();
        if (!this.itemsToWaitFor.containsKey(itemName)) {
            return;
        }
        if (payload.getValue() == null || payload.getValue().isEmpty()) {
            return;
        }
        DataTypeInstance instance = this.itemsToWaitFor.get(itemName);
        instance.parse(payload.getValue());
        this.returnValues.add(instance);
        this.eventSignal.countDown();
    }

    private void setAllItemsToWaitForAndServerBasePath(List<DataTypeInstance> parameter) {
        this.itemsToWaitFor = new HashMap<String, DataTypeInstance>();
        for (DataTypeInstance dataTypeInstance : parameter) {
            String name = dataTypeInstance.getDataTypeType().getName();
            if (serverType.equals(name)) {
                this.uriBasePath = (String)dataTypeInstance.getValueAsObject();
                continue;
            }
            this.itemsToWaitFor.put(name, dataTypeInstance);
        }
    }

    private void setTimeoutIfPresent(List<DataTypeInstance> parameter) {
        this.timeoutReturnList = parameter;
        Optional<DataTypeInstance> instance = parameter.stream().filter(d -> timeoutType.equals(d.getDataTypeType().getName())).filter(d -> d instanceof IntegerTypeInstance).findFirst();
        if (!instance.isPresent()) {
            return;
        }
        long delay = ((IntegerTypeInstance)instance.get()).getValue();
        Timer timer = new Timer();
        timer.schedule(new TimerTask(){

            @Override
            public void run() {
                OpenHabWaitForEvent.this.timeoutHappend = true;
                OpenHabWaitForEvent.this.eventSignal.countDown();
            }
        }, delay);
    }
}

