/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import eu.vicci.process.kodi.util.KodiPlayer;
import eu.vicci.process.kodi.util.KodiRemote;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KodiRemoteWorker
implements ProcessStepWorker {
    private static final Logger logger = LoggerFactory.getLogger(KodiRemoteWorker.class);
    public static final String SERVER_TYPE_ID = "KodiServer";
    public static final String METHOD_TYPE_ID = "KodiMethod";
    public static final String KODI_OPEN_TYPE_ID = "KodiOpenType";
    public static final String KODI_ITEM_TYPE_ID = "KodiItem";
    public static final String KODI_TITLE_TYPE_ID = "KodiTitle";
    public static final String KODI_MESSAGE_TYPE_ID = "KodiMessage";
    public static final String KODI_DISPLAYTIME_TYPE_ID = "KodiTime";
    private String serverPath;
    private String method;

    @Override
    public void deploy() {
    }

    @Override
    public List<DataTypeInstance> work(ProcessStepWorker.Context context) {
        this.setServerAndMethod(context.startParameter);
        if (this.isMethodOrServerEmpty()) {
            logger.error("Method or server path is empty. No Kodi remote command is send");
            return context.startParameter;
        }
        KodiRemote remote = new KodiRemote(this.serverPath);
        switch (this.method) {
            case "Player.Open": {
                this.playerOpen(context.startParameter, remote);
                break;
            }
            case "Player.Stop": {
                remote.stop(0);
                break;
            }
            case "GUI.ShowNotification": {
                this.guiNotification(context.startParameter, remote);
                break;
            }
            default: {
                throw new UnsupportedOperationException(String.format("The kodi method %s is not implemented yet.", this.method));
            }
        }
        return context.startParameter;
    }

    private void playerOpen(List<DataTypeInstance> parameter, KodiRemote remote) {
        String item = this.getValueFromParameters(parameter, KODI_ITEM_TYPE_ID, String.class);
        String openType = this.getValueFromParameters(parameter, KODI_OPEN_TYPE_ID, String.class);
        if (item == null || openType == null) {
            logger.error("Required parameters are missing (item or open type)");
            return;
        }
        remote.open(item, KodiPlayer.PlayerOpenType.fromString(openType));
    }

    private void guiNotification(List<DataTypeInstance> parameter, KodiRemote remote) {
        String title = this.getValueFromParameters(parameter, KODI_TITLE_TYPE_ID, String.class);
        String message = this.getValueFromParameters(parameter, KODI_MESSAGE_TYPE_ID, String.class);
        Integer time = this.getValueFromParameters(parameter, KODI_DISPLAYTIME_TYPE_ID, Integer.class);
        if (title == null || message == null || time == null) {
            logger.error("Required parameters are missing (title, message or displaytime)");
            return;
        }
        remote.sendNotification(title, message, time);
    }

    private void setServerAndMethod(List<DataTypeInstance> parameter) {
        for (DataTypeInstance dataTypeInstance : parameter) {
            if (!(dataTypeInstance instanceof StringTypeInstance)) continue;
            String name = dataTypeInstance.getDataTypeType().getName();
            if (SERVER_TYPE_ID.equals(name)) {
                this.serverPath = (String)dataTypeInstance.getValueAsObject();
                continue;
            }
            if (!METHOD_TYPE_ID.equals(name)) continue;
            this.method = (String)dataTypeInstance.getValueAsObject();
        }
    }

    private boolean isMethodOrServerEmpty() {
        return this.serverPath == null || this.method == null || this.serverPath.isEmpty() || this.method.isEmpty();
    }

    private <T> T getValueFromParameters(List<DataTypeInstance> parameter, String typeName, Class<T> clazz) {
        Optional<DataTypeInstance> instance = parameter.stream().filter(d -> d.getDataTypeType().getName().equals(typeName)).findFirst();
        if (!instance.isPresent()) {
            return null;
        }
        Object value = instance.get().getValueAsObject();
        if (value.getClass().equals(clazz)) {
            return (T)value;
        }
        return null;
    }
}

