/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import eu.vicci.process.model.sofia.IntegerType;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import java.util.List;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Delay
implements ProcessStepWorker {
    private static final Logger logger = LoggerFactory.getLogger(Delay.class);
    private static final String DELAY_TYPE_ID = "WorkerDelay";
    private static final long DEFAULT_DELAY = 6000L;

    @Override
    public void deploy() {
    }

    @Override
    public List<DataTypeInstance> work(ProcessStepWorker.Context context) {
        long delay = 6000L;
        Integer tmp = this.getCustomDelayFromStartPorts(context.startParameter);
        if (tmp != null) {
            delay = tmp.longValue();
        }
        logger.debug("Delay says: 'I delay execution for {} ms.'", (Object)delay);
        try {
            this.wait(delay);
        }
        catch (InterruptedException e) {
            logger.error("ProcessStepWorker 'Delay' failed. The waiting was interrupted");
            e.printStackTrace();
        }
        return context.startParameter;
    }

    private Integer getCustomDelayFromStartPorts(List<DataTypeInstance> parameter) {
        Optional<DataTypeInstance> instance = parameter.stream().filter(d -> DELAY_TYPE_ID.equals(d.getDataTypeType().getName())).filter(d -> d.getDataTypeType() instanceof IntegerType).findFirst();
        if (instance.isPresent()) {
            return (Integer)instance.get().getValueAsObject();
        }
        return null;
    }
}

