/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import com.google.gson.Gson;
import com.google.gson.JsonObject;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.AbstractStep;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.concurrent.CountDownLatch;
import java.util.stream.Collectors;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.apache.log4j.Logger;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;

public class Compensation
extends AbstractStep {
    private static final Logger LOG = Logger.getLogger(Compensation.class);
    private static final String GOAL = "Goal";
    private static final String CONTEXT_URI = "ContextUri";
    private static final String SERVICE_URI = "FeedbackServiceUri";
    private static final String WORKFLOW_NAME = "WorkflowName";
    private static final String HAS_BEEN_SATISFIED = "HasBeenSatisfied";
    private static final String HAS_BEEN_FINISHED = "HasBeenFinished";
    private final Gson parser = new Gson();
    private CloseableHttpClient httpClient;
    private Client sseClient;
    private String workflowUri;
    private String serviceUri;
    private boolean hasBeenSatisfied = false;
    private boolean hasBeenFinished = true;
    private CountDownLatch waitForEvent;

    @Override
    protected void work() {
        this.waitForEvent = new CountDownLatch(1);
        this.prepare();
        LOG.info((Object)"Start compensating feedback loop");
        this.createWorkflow();
        LOG.info((Object)String.format("Workflow %s created", this.workflowUri));
        this.waitForEvent();
        this.createGoals();
        LOG.info((Object)"Goals created. Waiting for feedback loop");
        try {
            this.waitForEvent.await();
            LOG.info((Object)String.format("Workflow done. Satisfaction is %s", this.hasBeenSatisfied));
        }
        catch (InterruptedException e) {
            LOG.error((Object)"I'm interrupted...", (Throwable)e);
        }
        finally {
            this.publishExecutionFlags();
            this.deleteWorkflow();
            this.finish();
        }
    }

    private void createWorkflow() {
        JsonObject workflow = new JsonObject();
        workflow.addProperty("name", this.stringParameter(WORKFLOW_NAME) + "." + this.instanceId);
        workflow.addProperty("context", this.stringParameter(CONTEXT_URI));
        this.workflowUri = this.post("workflows", workflow.toString()).get("_links").getAsJsonObject().get("self").getAsJsonObject().get("href").getAsString();
    }

    private void createGoals() {
        this.goals().stream().map(it -> (JsonObject)this.parser.fromJson(it, JsonObject.class)).forEach(it -> {
            it.addProperty("workflow", UriBuilder.fromPath((String)this.workflowUri).build(new Object[0]).toString());
            String goalUri = this.post("goals", it.toString()).get("_links").getAsJsonObject().get("self").getAsJsonObject().get("href").getAsString();
            LOG.info((Object)String.format("Goal %s created", goalUri));
        });
    }

    private void waitForEvent() {
        new Thread(() -> {
            InboundEvent event;
            EventInput eventInput = (EventInput)this.sseClient.target(UriBuilder.fromPath((String)this.serviceUri).path("events").path(UriBuilder.fromPath((String)this.workflowUri).build(new Object[0]).getPath())).request().get(EventInput.class);
            while (!eventInput.isClosed() && !this.workflowHasBeenDone((event = (InboundEvent)eventInput.read()).readData())) {
            }
            this.waitForEvent.countDown();
        }).start();
    }

    private boolean workflowHasBeenDone(String json) {
        JsonObject workflow = (JsonObject)this.parser.fromJson(json, JsonObject.class);
        this.hasBeenSatisfied = workflow.get("hasBeenSatisfied").getAsBoolean();
        this.hasBeenFinished = workflow.get("hasBeenFinished").getAsBoolean();
        return this.hasBeenFinished || this.hasBeenSatisfied;
    }

    private void publishExecutionFlags() {
        this.addOutgoing((DataTypeInstance)this.booleanNamed(HAS_BEEN_SATISFIED, this.hasBeenSatisfied));
        this.addOutgoing((DataTypeInstance)this.booleanNamed(HAS_BEEN_FINISHED, this.hasBeenFinished));
    }

    private void deleteWorkflow() {
        try {
            this.httpClient.execute((HttpUriRequest)new HttpDelete(UriBuilder.fromPath((String)this.workflowUri).build(new Object[0])));
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private JsonObject post(String path, String json) {
        URI uri = UriBuilder.fromPath((String)this.serviceUri).path(path).build(new Object[0]);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)entity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void prepare() {
        this.httpClient = HttpClients.createDefault();
        this.sseClient = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
        this.serviceUri = this.stringParameter(SERVICE_URI);
    }

    private void finish() {
        try {
            this.httpClient.close();
            this.sseClient.close();
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private Collection<String> goals() {
        return this.parameters(GOAL, StringType.class).map(it -> (String)it).collect(Collectors.toSet());
    }
}

