/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util.processstepclasses;

import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofia.StringType;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.ProcessStepWorker;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Stream;

public abstract class AbstractStep
implements ProcessStepWorker {
    private List<DataTypeInstance> input;
    private List<DataTypeInstance> outPorts = new ArrayList<DataTypeInstance>();
    private List<DataTypeInstance> output = new ArrayList<DataTypeInstance>();
    protected String instanceId;

    @Override
    public List<DataTypeInstance> work(ProcessStepWorker.Context context) {
        this.input = context.startParameter;
        this.outPorts = context.endParameter;
        this.instanceId = context.instanceId;
        this.work();
        return this.output;
    }

    protected void addOutgoing(DataTypeInstance instance) {
        this.output.add(instance);
    }

    protected Stream<Object> parameters(String name, Class<? extends DataType> typeClass) {
        return this.input.stream().filter(it -> name.equals(it.getDataTypeType().getName())).filter(it -> typeClass.isInstance(it.getDataTypeType())).map(DataTypeInstance::getValueAsObject).filter(it -> {
            if (it != null && it instanceof String) {
                return !((String)it).isEmpty();
            }
            return it != null;
        });
    }

    protected String stringParameter(String name) {
        return this.parameters(name, StringType.class).map(it -> (String)it).findFirst().orElseThrow(() -> new RuntimeException(name + " missing"));
    }

    protected BooleanTypeInstance booleanNamed(String typeName, boolean value) {
        for (DataTypeInstance dti : this.outPorts) {
            if (!typeName.equals(dti.getName())) continue;
            ((BooleanTypeInstance)dti).setValue(value);
            return (BooleanTypeInstance)dti;
        }
        throw new RuntimeException("No DataTypeInstance found for " + typeName);
    }

    @Override
    public void deploy() {
    }

    protected abstract void work();
}

