/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import eu.vicci.process.model.sofia.XMLRPCInvoke;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import org.apache.xmlrpc.XmlRpcException;
import org.apache.xmlrpc.client.XmlRpcClient;
import org.apache.xmlrpc.client.XmlRpcClientConfig;
import org.apache.xmlrpc.client.XmlRpcClientConfigImpl;
import org.apache.xmlrpc.client.XmlRpcSunHttpTransportFactory;
import org.apache.xmlrpc.client.XmlRpcTransportFactory;

public class XMLRPCInvokeWorker {
    XmlRpcClientConfigImpl config = new XmlRpcClientConfigImpl();
    static XmlRpcClient client = new XmlRpcClient();
    private List<DataTypeInstance> returnedValues = new LinkedList<DataTypeInstance>();

    public List<DataTypeInstance> work(ProcessStepInstance xsi) {
        XMLRPCInvoke inv = (XMLRPCInvoke)xsi.getProcessStepType();
        Vector<Object> params = new Vector<Object>();
        for (PortInstance pi : xsi.getPorts()) {
            if (!(pi instanceof StartDataPortInstance)) continue;
            StartDataPortInstance sdpi = (StartDataPortInstance)pi;
            DataTypeInstance dti = sdpi.getDataInstance();
            if (dti instanceof StringTypeInstance) {
                StringTypeInstance sti = (StringTypeInstance)dti;
                params.add(new String(sti.getValue()));
                continue;
            }
            if (dti instanceof IntegerTypeInstance) {
                IntegerTypeInstance iti = (IntegerTypeInstance)dti;
                params.add(new Integer(iti.getValue()));
                continue;
            }
            if (dti instanceof DoubleTypeInstance) {
                DoubleTypeInstance doti = (DoubleTypeInstance)dti;
                params.add(new Double(doti.getValue()));
                continue;
            }
            if (!(dti instanceof BooleanTypeInstance)) continue;
            BooleanTypeInstance bti = (BooleanTypeInstance)dti;
            params.add(new Boolean(bti.isValue()));
        }
        Vector result = null;
        try {
            this.config.setServerURL(new URL(inv.getServerUri()));
            this.config.setEnabledForExtensions(true);
            this.config.setConnectionTimeout(60000);
            this.config.setReplyTimeout(60000);
            client.setTransportFactory((XmlRpcTransportFactory)new XmlRpcSunHttpTransportFactory(client));
            client.setConfig((XmlRpcClientConfig)this.config);
            result = (Vector)client.execute(inv.getMethodName(), params);
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (XmlRpcException e) {
            e.printStackTrace();
        }
        String endParameterSequence = inv.getEndParameterSequence();
        ArrayList endParameters = new ArrayList();
        Collections.addAll(endParameters, endParameterSequence.split(";"));
        for (int i = 0; i < result.size(); ++i) {
            for (PortInstance portie : xsi.getPorts()) {
                EndDataPortInstance porte;
                if (!(portie instanceof EndDataPortInstance) || !(porte = (EndDataPortInstance)portie).getPortType().getName().equals(endParameters.get(i))) continue;
                DataTypeInstance dti = porte.getDataInstance();
                if (dti instanceof StringTypeInstance) {
                    StringTypeInstance sti = (StringTypeInstance)dti;
                    String str = (String)result.get(i);
                    sti.setValue(str);
                    porte.setDataInstance((DataTypeInstance)sti);
                    continue;
                }
                if (dti instanceof IntegerTypeInstance) {
                    IntegerTypeInstance iti = (IntegerTypeInstance)dti;
                    Integer integ = (Integer)result.get(i);
                    iti.setValue(integ.intValue());
                    porte.setDataInstance((DataTypeInstance)iti);
                    continue;
                }
                if (dti instanceof DoubleTypeInstance) {
                    DoubleTypeInstance doti = (DoubleTypeInstance)dti;
                    Double doub = (Double)result.get(i);
                    doti.setValue(doub.doubleValue());
                    porte.setDataInstance((DataTypeInstance)doti);
                    continue;
                }
                if (!(dti instanceof BooleanTypeInstance)) continue;
                BooleanTypeInstance bti = (BooleanTypeInstance)dti;
                Boolean bool = (Boolean)result.get(i);
                bti.setValue(bool.booleanValue());
                porte.setDataInstance((DataTypeInstance)bti);
            }
        }
        for (PortInstance pi : xsi.getPorts()) {
            if (!(pi instanceof EndDataPortInstance)) continue;
            EndDataPortInstance edpi = (EndDataPortInstance)pi;
            DataTypeInstance dti = edpi.getDataInstance();
            this.returnedValues.add(dti);
        }
        return this.returnedValues;
    }
}

