/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import com.espertech.esper.client.EPStatement;
import com.espertech.esper.client.EventBean;
import eu.vicci.process.model.cep.EsperManager;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.Optional;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggeredEventWorker {
    private static final Logger logger = LoggerFactory.getLogger(TriggeredEventWorker.class);
    private static final String SELECT = "select";
    private static final String FROM = "from";
    private static final String PLACEHOLDER_START = "<{";
    private static final String PLACEHOLDER_END = "}>";
    private static final String MISSING_END = "The given EPL statement contains the start tag for a placeholder but no endtag. Check the epl statement! \nStatement: '%s'";
    private static final String MISSING_VALUE = "A value for the placeholder name '%s' can not be found. The EPL statement wont compile!";
    private static final String MISSING_FIELD = "The field '{}' was not found in the epl statement (select). It is possible that the enport '{}' is never activated.";
    private static final String MISSING_TYPE = "The datatype of a port should not be empty. Check your process model!";
    private CountDownLatch eventTriggeredLatch = new CountDownLatch(1);
    private EventBean[] newData = null;
    private EPStatement stmt = null;

    public List<DataTypeInstance> work(String eplStatement, List<DataTypeInstance> startParameter, List<EndDataPortInstance> endports) {
        String replacedEpl = TriggeredEventWorker.replacePlaceholder(eplStatement, startParameter);
        this.stmt = EsperManager.getInstance().addEPLStatement(replacedEpl, this);
        try {
            this.eventTriggeredLatch.await();
        }
        catch (InterruptedException e1) {
            logger.error("waiting for event was interrupted");
            e1.printStackTrace();
            return null;
        }
        return this.getReturnedValues(replacedEpl, endports);
    }

    public void activate(EventBean[] newData, EventBean[] oldData) {
        EsperManager.getInstance().removeEPLStatement(this.stmt);
        this.safeSetNewData(newData);
        this.eventTriggeredLatch.countDown();
    }

    public void reset() {
        this.eventTriggeredLatch = new CountDownLatch(1);
        this.newData = null;
        if (this.stmt != null) {
            EsperManager.getInstance().removeEPLStatement(this.stmt);
        }
        this.stmt = null;
    }

    private synchronized void safeSetNewData(EventBean[] received) {
        if (this.newData == null) {
            this.newData = received;
        }
    }

    private List<DataTypeInstance> getReturnedValues(String eplStmt, List<EndDataPortInstance> endports) {
        LinkedList<DataTypeInstance> returnedValues = new LinkedList<DataTypeInstance>();
        if (this.newData == null || this.newData.length == 0) {
            return returnedValues;
        }
        List<String> selection = TriggeredEventWorker.getSelection(eplStmt);
        for (EndDataPortInstance endport : endports) {
            this.addToListIfMatches(endport, selection, returnedValues);
        }
        return returnedValues;
    }

    private void addToListIfMatches(EndDataPortInstance endport, List<String> selection, List<DataTypeInstance> returnedValues) {
        DataTypeInstance dti = endport.getDataInstance();
        if (dti == null) {
            throw new IllegalArgumentException(MISSING_TYPE);
        }
        String name = dti.getDataTypeType().getName();
        if (!selection.contains(name)) {
            logger.warn(MISSING_FIELD, (Object)name, (Object)endport.getName());
            return;
        }
        Object value = this.newData[0].get(name);
        if (value == null) {
            logger.error("The value received by the select was NULL. DataInstance can not be created!");
            return;
        }
        dti.parse(value.toString());
        returnedValues.add(dti);
    }

    private static List<String> getSelection(String eplStmt) {
        String[] split;
        ArrayList<String> selections = new ArrayList<String>();
        String lowerString = eplStmt.toLowerCase();
        int start = lowerString.indexOf(SELECT);
        int end = lowerString.indexOf(FROM);
        String tmp = eplStmt.substring(start + SELECT.length(), end);
        for (String string : split = tmp.split(",")) {
            selections.add(string.trim());
        }
        return selections;
    }

    private static String replacePlaceholder(String eplStmt, List<DataTypeInstance> startParameter) {
        if (!eplStmt.contains(PLACEHOLDER_START)) {
            return eplStmt;
        }
        int start = eplStmt.indexOf(PLACEHOLDER_START);
        int end = eplStmt.indexOf(PLACEHOLDER_END);
        if (end < 0) {
            throw new IllegalArgumentException(String.format(MISSING_END, eplStmt));
        }
        String name = eplStmt.substring(start + PLACEHOLDER_START.length(), end);
        String trimmedName = name.trim();
        Object value = TriggeredEventWorker.getValueForPlaceholder(trimmedName, startParameter);
        if (value == null) {
            throw new IllegalArgumentException(String.format(MISSING_VALUE, trimmedName));
        }
        String newEpl = eplStmt.replace(PLACEHOLDER_START + name + PLACEHOLDER_END, value.toString());
        return TriggeredEventWorker.replacePlaceholder(newEpl, startParameter);
    }

    private static Object getValueForPlaceholder(String name, List<DataTypeInstance> startParameter) {
        Optional<DataTypeInstance> valueHolder = startParameter.stream().filter(d -> d.getName().equals(name)).findFirst();
        if (valueHolder.isPresent()) {
            return valueHolder.get().getValueAsObject();
        }
        return null;
    }
}

