/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import eu.vicci.process.distribution.core.DistributedSession;
import eu.vicci.process.distribution.core.DistributionManagerListener;
import eu.vicci.process.distribution.core.IDistributionManager;
import eu.vicci.process.distribution.core.RemoteProcess;
import eu.vicci.process.distribution.manager.DistributionManager;
import eu.vicci.process.model.sofia.Process;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.DistributingProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.states.StateBase;
import eu.vicci.process.model.util.messages.core.IStateChangeMessage;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class RemoteStepInvokeWorker {
    private static final Logger LOGGER = LoggerFactory.getLogger(RemoteStepInvokeWorker.class);
    public List<DataTypeInstance> returnedData = new LinkedList<DataTypeInstance>();
    private CountDownLatch responseReceived;
    private DistributedSession remoteSession;
    private DistributingProcessInstanceImplCustom processInstance;
    private IDistributionManager distributionManager = DistributionManager.getInstance();
    private volatile IStateChangeMessage finalMessage;
    private DistributionManagerListener listener = new DistributionManagerListener(){

        public void processOnPeerHasFinished(IStateChangeMessage message, DistributedSession session) {
            if (!RemoteStepInvokeWorker.this.remoteSession.equals((Object)session)) {
                return;
            }
            State messageState = message.getState();
            if (messageState != State.FAILED && messageState != State.DEACTIVATED) {
                RemoteStepInvokeWorker.this.finalMessage = message;
            }
            RemoteStepInvokeWorker.this.responseReceived.countDown();
        }

        public void remoteSessionChanged(DistributedSession oldSession, DistributedSession newSession) {
            if (!RemoteStepInvokeWorker.this.remoteSession.equals((Object)oldSession)) {
                return;
            }
            RemoteStepInvokeWorker.this.remoteSession = newSession;
        }
    };

    public RemoteStepInvokeWorker(DistributingProcessInstanceImplCustom processInstance, IDistributionManager distributionManager) {
        this.processInstance = processInstance;
        this.distributionManager = distributionManager;
        this.checkArgs();
    }

    public Map<String, IJSONDataPortInstance> getEndDataPorts() {
        return this.finalMessage.getEndDataPorts();
    }

    public boolean receivedFinalMessage() {
        return this.finalMessage != null;
    }

    public Map<String, IJSONPortInstance> getEndControlPorts() {
        return this.finalMessage.getEndControlPorts();
    }

    private void checkArgs() {
        if (this.processInstance == null) {
            throw new IllegalArgumentException("worker does not contain a process instance to execute remote");
        }
        if (this.distributionManager == null) {
            throw new IllegalArgumentException("no DistributionManager available. Cant remote execute process. At the moment no option implemented to execute the process local in this case");
        }
    }

    public void work() {
        LOGGER.debug("---->>>> Executing distributed Process Step");
        this.responseReceived = new CountDownLatch(1);
        Process process = (Process)this.processInstance.getProcessStepType();
        String ip = process.getExecutionPeer();
        if (ip == null || ip.isEmpty()) {
            throw new RuntimeException("no remote peer defined in process");
        }
        StateBase oldState = this.processInstance.getCurrentState();
        RemoteProcess remoteProcess = this.distributionManager.createRemoteProcess(process);
        Map<String, DataTypeInstance> inputParameters = this.getInputParameters();
        this.distributionManager.addDistributionManagerListener(this.listener);
        this.remoteSession = this.distributionManager.workRemote(ip, this.processInstance.getInstanceId(), remoteProcess, inputParameters);
        try {
            this.responseReceived.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        LOGGER.debug("---- Remote Execution Returned");
        this.distributionManager.removeDistributionManagerListener(this.listener);
    }

    public void forceFinish() {
        this.responseReceived.countDown();
    }

    private Map<String, DataTypeInstance> getInputParameters() {
        if (!this.processInstance.getPorts().stream().anyMatch(p -> p instanceof StartDataPortInstance)) {
            return null;
        }
        HashMap<String, DataTypeInstance> result = new HashMap<String, DataTypeInstance>();
        this.processInstance.getPorts().stream().filter(p -> p instanceof StartDataPortInstance).map(StartDataPortInstance.class::cast).map(DataPortInstance::getDataInstance).forEach(dti -> result.put(dti.getDataTypeType().getId(), (DataTypeInstance)dti));
        return result;
    }
}

