/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import com.google.gson.Gson;
import com.google.gson.internal.LinkedTreeMap;
import eu.vicci.process.model.sofia.ROSInvoke;
import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.DoubleTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.IntegerTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.StringTypeInstance;
import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class ROSInvokeWorker
extends WebSocketClient {
    private String serviceName;
    private boolean connected = false;
    private String serviceCallAnswer = "";
    private boolean serviceCall = false;
    private boolean answerReceived = false;
    private List<DataTypeInstance> returnedData = new LinkedList<DataTypeInstance>();

    public ROSInvokeWorker(URI serverURI) {
        super(serverURI);
    }

    public List<DataTypeInstance> work(ProcessStepInstance rii) {
        DataTypeInstance dti;
        StringTypeInstance data;
        ROSInvoke ri = (ROSInvoke)rii.getProcessStepType();
        this.serviceName = ri.getServiceName();
        LinkedTreeMap call = new LinkedTreeMap();
        call.put((Object)"op", (Object)"call_service");
        call.put((Object)"service", (Object)this.serviceName);
        LinkedTreeMap arguments = new LinkedTreeMap();
        for (PortInstance pi : rii.getPorts()) {
            if (pi instanceof StartDataPortInstance) {
                StartDataPortInstance sdpi = (StartDataPortInstance)pi;
                DataTypeInstance type = sdpi.getDataInstance();
                String name = type.getDataTypeType().getName();
                if (type instanceof StringTypeInstance) {
                    data = (StringTypeInstance)type;
                    String value = data.getValue();
                    arguments.put((Object)name, (Object)value);
                } else if (type instanceof IntegerTypeInstance) {
                    data = (IntegerTypeInstance)type;
                    int value = data.getValue();
                    arguments.put((Object)name, (Object)value);
                } else if (type instanceof DoubleTypeInstance) {
                    data = (DoubleTypeInstance)type;
                    double value = data.getValue();
                    arguments.put((Object)name, (Object)value);
                } else if (type instanceof BooleanTypeInstance) {
                    data = (BooleanTypeInstance)type;
                    boolean value = data.isValue();
                    arguments.put((Object)name, (Object)value);
                }
            }
            call.put((Object)"args", (Object)arguments);
        }
        Gson gson = new Gson();
        String message = gson.toJson((Object)call);
        System.out.println("Invoke message: " + message);
        this.send(message);
        while (!this.answerReceived) {
            try {
                Thread.sleep(100L);
            }
            catch (InterruptedException e) {
                e.printStackTrace();
            }
        }
        String response = this.serviceCallAnswer;
        Gson respgson = new Gson();
        Map map = new HashMap();
        map = (Map)respgson.fromJson(response, map.getClass());
        data = null;
        if (map.containsKey("values")) {
            data = (LinkedTreeMap)map.get("values");
        }
        for (PortInstance porti : rii.getPorts()) {
            if (!(porti instanceof EndDataPortInstance)) continue;
            DataPortInstance dpie = (DataPortInstance)porti;
            if (data == null) continue;
            dti = dpie.getDataInstance();
            String key = dti.getDataTypeType().getName();
            Object value = ROSInvokeWorker.traverse(key, (LinkedTreeMap)data);
            if (dti instanceof StringTypeInstance) {
                StringTypeInstance sti = (StringTypeInstance)dti;
                String str = (String)value;
                sti.setValue(str);
                dpie.setDataInstance((DataTypeInstance)sti);
                continue;
            }
            if (dti instanceof IntegerTypeInstance) {
                IntegerTypeInstance iti = (IntegerTypeInstance)dti;
                Integer integ = (Integer)value;
                iti.setValue(integ.intValue());
                dpie.setDataInstance((DataTypeInstance)iti);
                continue;
            }
            if (dti instanceof DoubleTypeInstance) {
                DoubleTypeInstance doti = (DoubleTypeInstance)dti;
                Double doub = (Double)value;
                doti.setValue(doub.doubleValue());
                dpie.setDataInstance((DataTypeInstance)doti);
                continue;
            }
            if (!(dti instanceof BooleanTypeInstance)) continue;
            BooleanTypeInstance bti = (BooleanTypeInstance)dti;
            Boolean bool = (Boolean)value;
            bti.setValue(bool.booleanValue());
            dpie.setDataInstance((DataTypeInstance)bti);
        }
        for (PortInstance pi : rii.getPorts()) {
            if (!(pi instanceof EndDataPortInstance)) continue;
            EndDataPortInstance edpi = (EndDataPortInstance)pi;
            dti = edpi.getDataInstance();
            this.returnedData.add(dti);
        }
        return this.returnedData;
    }

    public void onClose(int arg0, String arg1, boolean arg2) {
        this.connected = false;
    }

    public void onError(Exception arg0) {
    }

    public void onMessage(String s) {
        if (s.contains(this.serviceName) && s.contains("service_response")) {
            this.serviceCallAnswer = s;
            this.answerReceived = true;
            System.out.println("Answer: " + this.serviceCallAnswer);
        }
    }

    public void onOpen(ServerHandshake arg0) {
        this.connected = true;
        System.out.println("Connected");
    }

    public String getServiceName() {
        return this.serviceName;
    }

    public void setServiceName(String serviceName) {
        this.serviceName = serviceName;
    }

    public String getServiceCallAnswer() {
        return this.serviceCallAnswer;
    }

    public boolean isServiceCall() {
        return this.serviceCall;
    }

    public void setServiceCall(boolean serviceCall) {
        this.serviceCall = serviceCall;
    }

    public boolean isConnected() {
        return this.connected;
    }

    public boolean isAnswerReceived() {
        return this.answerReceived;
    }

    public void setAnswerReceived(boolean answerReceived) {
        this.answerReceived = answerReceived;
    }

    private static Object traverse(String key, LinkedTreeMap ltm) {
        Object value = "";
        if (ltm.containsKey((Object)key)) {
            value = ltm.get((Object)key);
        } else {
            for (Object o : ltm.values()) {
                if (o instanceof ArrayList) {
                    ArrayList al = (ArrayList)o;
                    for (Object o2 : al) {
                        if (!(o2 instanceof LinkedTreeMap)) continue;
                        LinkedTreeMap ltm3 = (LinkedTreeMap)o2;
                        value = ROSInvokeWorker.traverse(key, ltm3);
                    }
                    continue;
                }
                if (!(o instanceof LinkedTreeMap)) continue;
                LinkedTreeMap ltm2 = (LinkedTreeMap)o;
                value = ROSInvokeWorker.traverse(key, ltm2);
            }
        }
        return value;
    }
}

