/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import eu.vicci.process.model.sofia.CompositeStep;
import eu.vicci.process.model.sofia.Port;
import eu.vicci.process.model.sofia.ProcessStep;
import eu.vicci.process.model.sofiainstance.Configuration;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.EndPortInstance;
import eu.vicci.process.model.sofiainstance.ExecutionPermission;
import eu.vicci.process.model.sofiainstance.MappingUtil;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.util.InternalProcessStepInterface;
import eu.vicci.process.model.sofiainstance.util.ProcessStepTimerTask;
import java.util.Timer;
import java.util.TimerTask;
import org.eclipse.emf.common.util.EList;

public class ProcessStepUtil {
    public static boolean execute(ProcessStepInstance inst) {
        InternalProcessStepInterface instUtil = null;
        if (inst instanceof InternalProcessStepInterface) {
            instUtil = (InternalProcessStepInterface)inst;
        }
        instUtil.logInfo(inst.getExecutionState().toString() + " permission: " + inst.getPermission());
        try {
            switch (inst.getExecutionState()) {
                default: {
                    System.out.println("Execution denied. state: " + inst.getExecutionState());
                    break;
                }
                case INACTIVE: {
                    instUtil.logInfo("-------------> execution started");
                    instUtil.changeExecutionState(State.ACTIVE);
                    inst.execute();
                    return true;
                }
                case EXECUTED: {
                    instUtil.forwardReactivation();
                    return true;
                }
                case ACTIVE: {
                    if (instUtil.allStartPortsActive()) {
                        switch (inst.getPermission()) {
                            case GRANTED: {
                                instUtil.cancelTimer();
                                instUtil.changeExecutionState(State.EXECUTING);
                                instUtil.startSubProcesses();
                                instUtil.aggregateStartParameter();
                                instUtil.aggregateEndParameter();
                                instUtil.work();
                                instUtil.activateControlEndPorts();
                                instUtil.activateDataEndPorts();
                                instUtil.changeExecutionState(State.EXECUTED);
                                instUtil.logInfo("-------------> execution finished");
                                return true;
                            }
                            case DENIED: {
                                return false;
                            }
                            case DELAYED: {
                                instUtil.executeDelay();
                                return false;
                            }
                        }
                        break;
                    }
                    return false;
                }
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
        return true;
    }

    public static void setPermission(ProcessStepInstance inst, ExecutionPermission newPermission) {
        if (inst.getExecutionState() == State.ACTIVE) {
            inst.execute();
        }
    }

    public static void setDelay(ProcessStepInstance inst, long newDelay) {
        InternalProcessStepInterface utilInst;
        inst.setDelay(newDelay);
        if (inst instanceof InternalProcessStepInterface && (utilInst = (InternalProcessStepInterface)inst).getTimer() != null && utilInst.getTimerTask() != null) {
            utilInst.getTimerTask().cancel();
            utilInst.getTimer().schedule((TimerTask)utilInst.getTimerTask(), newDelay);
        }
    }

    public static boolean allPortsActive(ProcessStepInstance inst) {
        boolean isAllActive = true;
        for (PortInstance port : inst.getPorts()) {
            if (!(port instanceof StartPortInstance)) continue;
            Port p = port.getPortType();
            if (port.getExecutionState() != State.INACTIVE || p.isOptional()) continue;
            isAllActive = false;
        }
        return isAllActive;
    }

    public static void forwardReactivation(ProcessStepInstance inst) {
        for (PortInstance port : inst.getPorts()) {
            if (!(port instanceof EndPortInstance)) continue;
            port.activate(null);
        }
    }

    public static void changeExecutionState(ProcessStepInstance inst, State state) {
        System.out.println(inst.getProcessStepType().getName() + ".changeState() oldstate:" + inst.getExecutionState() + "    newstate:" + state);
        inst.setExecutionState(state);
    }

    public static void startSubProcesses(ProcessStepInstance inst) {
        for (PortInstance port : inst.getPorts()) {
            if (!(port instanceof StartPortInstance)) continue;
            StartPortInstance startPort = (StartPortInstance)port;
            startPort.executeSubSteps();
        }
    }

    public static void cancelTimer(ProcessStepInstance inst) {
        InternalProcessStepInterface utilInst;
        if (inst instanceof InternalProcessStepInterface && (utilInst = (InternalProcessStepInterface)inst).getTimer() != null) {
            utilInst.getTimer().cancel();
        }
    }

    public static void aggregateStartParameter(ProcessStepInstance inst) {
        if (inst instanceof InternalProcessStepInterface) {
            InternalProcessStepInterface utilInst = (InternalProcessStepInterface)inst;
            for (PortInstance port : inst.getPorts()) {
                if (!(port instanceof DataPortInstance)) continue;
                DataPortInstance dataPortInstance = (DataPortInstance)port;
                utilInst.getStartParameter().add(dataPortInstance.getDataInstance());
            }
        }
    }

    public static void activateDataEndPorts(ProcessStepInstance inst) {
        InternalProcessStepInterface utilInst;
        if (inst instanceof InternalProcessStepInterface && !(utilInst = (InternalProcessStepInterface)inst).getReturnValues().isEmpty()) {
            for (PortInstance port : inst.getPorts()) {
                if (!(port instanceof EndDataPortInstance)) continue;
                DataPortInstance port1 = (DataPortInstance)port;
                for (DataTypeInstance dataInstance : utilInst.getReturnValues()) {
                    String wantedDataId;
                    String dataId = dataInstance.getDataTypeType().getName();
                    if (!dataId.equals(wantedDataId = port1.getDataInstance().getDataTypeType().getName())) continue;
                    port.activate(dataInstance);
                }
            }
        }
    }

    public static void activateControlEndPorts(ProcessStepInstance inst) {
        for (PortInstance port : inst.getPorts()) {
            if (!(port instanceof EndControlPortInstance)) continue;
            port.activate(null);
        }
    }

    public static void executeDelay(ProcessStepInstance inst) {
        InternalProcessStepInterface utilInst;
        if (inst instanceof InternalProcessStepInterface && (utilInst = (InternalProcessStepInterface)inst).getTimer() == null) {
            Timer timer = new Timer();
            ProcessStepTimerTask timerTask = new ProcessStepTimerTask(inst);
            timer.schedule((TimerTask)timerTask, inst.getDelay());
            System.err.println("Timer scheduled");
        }
    }

    public static void deploy(ProcessStepInstance inst, MappingUtil mapper) {
        if (inst.getExecutionState() == State.UNDEPLOYED) {
            inst.setExecutionState(State.INACTIVE);
            if (inst.getProcessStepType() instanceof CompositeStep) {
                CompositeStep parentStep = (CompositeStep)inst.getProcessStepType();
                EList steps = parentStep.getSubSteps();
                for (Object step : steps) {
                    ProcessStepInstance instance = mapper.mapProcessStep((ProcessStep)step);
                    instance.deploy(mapper);
                    inst.getSubSteps().add((Object)instance);
                }
            }
            for (Port p : inst.getProcessStepType().getPorts()) {
                if (!(p instanceof Port)) continue;
                boolean isMapped = false;
                for (ProcessStepInstance instance : inst.getPorts()) {
                    if (!instance.getPortType().getId().equals(p.getId())) continue;
                    isMapped = true;
                }
                if (isMapped) continue;
                PortInstance portInstance = mapper.mapPort(p);
                inst.getPorts().add((Object)portInstance);
                portInstance.deploy(mapper);
            }
        }
    }

    public static void configure(ProcessStepInstance inst, Configuration conf) {
        boolean correctId = false;
        System.out.println("configure step: " + inst.getProcessStepType().getId());
        if (inst.getProcessStepType().getId().equals(conf.getInstanceId())) {
            ProcessStepUtil.configure1(inst, conf);
            correctId = true;
        } else if (conf.getInstanceId() == null) {
            ProcessStepUtil.configure1(inst, conf);
        }
        if (inst.getProcessStepType() instanceof CompositeStep && !correctId) {
            for (ProcessStepInstance inst3 : inst.getSubSteps()) {
                inst3.configure(conf);
            }
        }
    }

    public static void consoleOutput(ProcessStepInstance inst, String info) {
        System.out.println(inst.getClass().getSimpleName() + ": " + info);
    }

    private static void configure1(ProcessStepInstance inst, Configuration conf) {
        if (conf.isDecoupleNextSteps()) {
            System.out.println("following steps decoupled");
            for (PortInstance portInstance : inst.getPorts()) {
                portInstance.setDecoupled(true);
            }
        }
        if (conf.getDelay() >= 0L) {
            inst.setDelay(conf.getDelay());
        }
        if (conf.getPermission() != null) {
            inst.setPermission(conf.getPermission());
        }
    }
}

