/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.TypedActor;
import akka.util.Timeout;
import eu.vicci.process.actors.ActorAssignable;
import eu.vicci.process.actors.EndPortActorFactory;
import eu.vicci.process.actors.IProcessExecutionMasterActor;
import eu.vicci.process.actors.ProcessExecutionMasterActor;
import eu.vicci.process.actors.ProcessStepActorFactory;
import eu.vicci.process.actors.StartControlPortActorFactory;
import eu.vicci.process.actors.StartDataPortActorFactory;
import eu.vicci.process.actors.TransitionActorFactory;
import eu.vicci.process.messages.ActivatePortMessage;
import eu.vicci.process.messages.ChangePortExecutionStateMessage;
import eu.vicci.process.messages.CreateChildActorMessage;
import eu.vicci.process.messages.DeactivatePortMessage;
import eu.vicci.process.messages.DeactivateProcessStepMessage;
import eu.vicci.process.messages.DeactivateTransitionMessage;
import eu.vicci.process.messages.EscalateProcessStepMessage;
import eu.vicci.process.messages.ExecuteProcessStepMessage;
import eu.vicci.process.messages.ExecuteTransitionMessage;
import eu.vicci.process.messages.KillProcessStepMessage;
import eu.vicci.process.messages.PauseProcessStepMessage;
import eu.vicci.process.messages.PortExecutionStateChangedMessage;
import eu.vicci.process.messages.ProcessExecutedMessage;
import eu.vicci.process.messages.ProcessResetMessage;
import eu.vicci.process.messages.ResetProcessMessage;
import eu.vicci.process.messages.ResumeProcessStepMessage;
import eu.vicci.process.messages.SetPortDataTypeInstanceMessage;
import eu.vicci.process.messages.StopProcessStepMessage;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.StartControlPortInstance;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.TransitionInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.states.PortExecutionStateChangedListener;
import eu.vicci.process.model.sofiainstance.states.ProcessExecutedListener;
import eu.vicci.process.model.sofiainstance.states.ProcessResetListener;
import java.util.concurrent.TimeUnit;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import scala.concurrent.Await;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.FiniteDuration;

public enum LifeCycleManager {
    INSTANCE;

    private static final String EXECUTION_SYSTEM_NAME = "processExecutionSystem";
    private static final String EXECUTION_MASTER_NAME = "executionMaster";
    private static final int DEFAULT_TIMEOUT = 5;
    private final FiniteDuration duration = Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS);
    private final Timeout timeout = new Timeout(this.duration);
    private ActorSystem processExecutionSystem;
    private IProcessExecutionMasterActor executionMaster;
    private final Logger logger = LoggerFactory.getLogger((String)"LifeCycleManager");

    private LifeCycleManager() {
        this.logger.debug("setting up the process execution system");
        this.processExecutionSystem = ActorSystem.create((String)EXECUTION_SYSTEM_NAME);
        this.logger.debug("created actorsystem");
        this.executionMaster = ProcessExecutionMasterActor.create(this.processExecutionSystem, EXECUTION_MASTER_NAME);
        this.logger.debug("created master");
    }

    public void activatePort(PortInstance port, DataTypeInstance parameter) {
        this.logger.debug("activate port: {}", (Object)port.getName());
        ActivatePortMessage message = new ActivatePortMessage(parameter);
        ActorRef receiver = ((ActorAssignable)port).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void activatePort(PortInstance port) {
        this.activatePort(port, null);
    }

    public boolean activatePortSync(PortInstance port) {
        return this.activatePortSync(port, null);
    }

    public boolean activatePortSync(PortInstance port, DataTypeInstance parameter) {
        this.logger.debug("activate port: {}", (Object)port.getName());
        ActivatePortMessage message = new ActivatePortMessage(parameter, true);
        ActorRef receiver = ((ActorAssignable)port).getActorReference();
        Future<Object> result = this.executionMaster.sendMessageAndReceiveFuture(receiver, message, this.timeout);
        try {
            return (Boolean)Await.result(result, (Duration)this.duration);
        }
        catch (Exception e) {
            this.logTimeoutPortActivation(port);
            e.printStackTrace();
            return false;
        }
    }

    public void executeTransition(TransitionInstance transition, DataTypeInstance parameter) {
        this.logTransition(transition);
        ExecuteTransitionMessage message = new ExecuteTransitionMessage(parameter);
        ActorRef receiver = ((ActorAssignable)transition).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void executeTransition(TransitionInstance transition) {
        this.executeTransition(transition, null);
    }

    public boolean executeTransitionSync(TransitionInstance transition, DataTypeInstance parameter) {
        this.logTransition(transition);
        ExecuteTransitionMessage message = new ExecuteTransitionMessage(parameter, true);
        ActorRef receiver = ((ActorAssignable)transition).getActorReference();
        Future<Object> result = this.executionMaster.sendMessageAndReceiveFuture(receiver, message, this.timeout);
        try {
            return (Boolean)Await.result(result, (Duration)this.duration);
        }
        catch (Exception e) {
            this.logTimeoutTransitionActivation(transition);
            e.printStackTrace();
            return false;
        }
    }

    public boolean executeTransitionSync(TransitionInstance transition) {
        return this.executeTransitionSync(transition, null);
    }

    public boolean executeProcessStep(ProcessStepInstance processStep) {
        this.logger.debug("executing process step: {}", (Object)processStep.getInstanceId());
        ExecuteProcessStepMessage message = new ExecuteProcessStepMessage();
        ActorRef receiver = ((ActorAssignable)processStep).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
        return true;
    }

    public void stopProcessStep(ActorAssignable processStep) {
        this.logger.debug("stopping process step: {}", (Object)processStep.getActorReference().path());
        ActorRef receiver = processStep.getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, new StopProcessStepMessage());
    }

    public void resumeProcessStep(ActorAssignable processStep) {
        this.logger.debug("resume process step: {}", (Object)processStep.getActorReference().path());
        ActorRef receiver = processStep.getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, new ResumeProcessStepMessage());
    }

    public void killProcessStep(ActorAssignable processStep) {
        this.logger.debug("kill process step: {}", (Object)processStep.getActorReference().path());
        ActorRef receiver = processStep.getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, new KillProcessStepMessage());
    }

    public void pauseProcessStep(ActorAssignable processStep) {
        this.logger.debug("pause process step: {}", (Object)processStep.getActorReference().path());
        ActorRef receiver = processStep.getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, new PauseProcessStepMessage());
    }

    public ActorRef createActorForEndPortSync(PortInstance endPort, ActorRef parent) {
        this.logger.debug("create actor for endport: {}", (Object)endPort.getInstanceId());
        EndPortActorFactory factory = new EndPortActorFactory(endPort);
        CreateChildActorMessage message = new CreateChildActorMessage(factory, endPort.getInstanceId());
        return this.executionMaster.createChildActor(parent, message);
    }

    public ActorRef createActorForProcessSync(ProcessStepInstanceImplCustom processStepInstance, ActorRef parent) {
        this.logger.debug("create actor for process: {}", (Object)processStepInstance.getInstanceId());
        ProcessStepActorFactory factory = new ProcessStepActorFactory(processStepInstance);
        CreateChildActorMessage message = new CreateChildActorMessage(factory, processStepInstance.getInstanceId());
        return this.executionMaster.createChildActor(parent, message);
    }

    public ActorRef createActorForStartControlPortSync(StartControlPortInstance portInstance, ActorRef parent) {
        this.logger.debug("create actor for startcontrolport: {}", (Object)portInstance.getInstanceId());
        StartControlPortActorFactory factory = new StartControlPortActorFactory(portInstance);
        CreateChildActorMessage message = new CreateChildActorMessage(factory, portInstance.getInstanceId());
        return this.executionMaster.createChildActor(parent, message);
    }

    public ActorRef createActorForStartDataPortSync(StartDataPortInstance portInstance, ActorRef parent) {
        this.logger.debug("create actor for startdataport: {}", (Object)portInstance.getInstanceId());
        StartDataPortActorFactory factory = new StartDataPortActorFactory(portInstance);
        CreateChildActorMessage message = new CreateChildActorMessage(factory, portInstance.getInstanceId());
        return this.executionMaster.createChildActor(parent, message);
    }

    public ActorRef createActorForTransitionSync(TransitionInstance instance, ActorRef parent) {
        this.logger.debug("create actor for transition: {}", (Object)instance.getInstanceId());
        TransitionActorFactory factory = new TransitionActorFactory(instance);
        CreateChildActorMessage message = new CreateChildActorMessage(factory, instance.getInstanceId());
        return this.executionMaster.createChildActor(parent, message);
    }

    public void processExecuted(ProcessExecutedListener listener, ProcessStepInstanceImplCustom executedProcess) {
        if (!(listener instanceof ActorAssignable)) {
            listener.processExecuted(executedProcess);
        } else {
            this.executionMaster.sendSimpleMessage(((ActorAssignable)((Object)listener)).getActorReference(), new ProcessExecutedMessage(executedProcess));
        }
    }

    public void processReset(ProcessResetListener listener, ProcessStepInstanceImplCustom resetProcess) {
        if (!(listener instanceof ActorAssignable)) {
            listener.processReset(resetProcess);
        } else {
            this.executionMaster.sendSimpleMessage(((ActorAssignable)((Object)listener)).getActorReference(), new ProcessResetMessage(resetProcess));
        }
    }

    public void stopActorSystem() {
        this.logger.debug("stopping the process execution master actor and shutdown process execution system");
        TypedActor.get((ActorSystem)this.processExecutionSystem).stop((Object)this.executionMaster);
        this.processExecutionSystem.shutdown();
        this.processExecutionSystem.awaitTermination();
    }

    public void deactivateTransition(TransitionInstance instance) {
        this.logger.debug("deactivating transition: {}", (Object)instance.getInstanceId());
        DeactivateTransitionMessage message = new DeactivateTransitionMessage();
        ActorRef receiver = ((ActorAssignable)instance).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void deactivateProcessStep(ProcessStepInstance processStep) {
        this.logger.debug("deactivating process step: {}", (Object)processStep.getInstanceId());
        DeactivateProcessStepMessage message = new DeactivateProcessStepMessage();
        ActorRef receiver = ((ActorAssignable)processStep).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void escalateProcessStep(ProcessStepInstance processStep) {
        this.logger.debug("escalate process step {}", (Object)processStep.getInstanceId());
        EscalateProcessStepMessage message = new EscalateProcessStepMessage();
        ActorRef receiver = ((ActorAssignable)processStep).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void deactivatePort(PortInstance port) {
        this.logger.debug("deactivating port: {}", (Object)port.getPortType().getName());
        DeactivatePortMessage message = new DeactivatePortMessage();
        ActorRef receiver = ((ActorAssignable)port).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void resetProcess(ProcessStepInstance process) {
        this.logger.debug("reset process step: {}", (Object)process.getInstanceId());
        ResetProcessMessage message = new ResetProcessMessage();
        ActorRef receiver = ((ActorAssignable)process).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void changePortExecutionState(PortInstance port, State newExecutionstate) {
        this.logger.debug("change port execution state: {}", (Object)port.getPortType().getName());
        ChangePortExecutionStateMessage message = new ChangePortExecutionStateMessage(newExecutionstate);
        ActorRef receiver = ((ActorAssignable)port).getActorReference();
        this.executionMaster.sendSimpleMessage(receiver, message);
    }

    public void portExecutionStateChanged(PortExecutionStateChangedListener listener, PortInstance port) {
        if (!(listener instanceof ActorAssignable)) {
            listener.portExecutionStateChanged(port);
        } else {
            this.executionMaster.sendSimpleMessage(((ActorAssignable)((Object)listener)).getActorReference(), new PortExecutionStateChangedMessage(port));
        }
    }

    public boolean setPortDataTypeInstanceSync(DataPortInstance port, DataTypeInstance dataTypeInstance) {
        ActorRef receiver = ((ActorAssignable)port).getActorReference();
        SetPortDataTypeInstanceMessage message = new SetPortDataTypeInstanceMessage(dataTypeInstance);
        Timeout timeout = new Timeout(Duration.create((long)5L, (TimeUnit)TimeUnit.SECONDS));
        Future<Object> result = this.executionMaster.sendMessageAndReceiveFuture(receiver, message, timeout);
        try {
            return (Boolean)Await.result(result, (Duration)timeout.duration());
        }
        catch (Exception e) {
            e.printStackTrace();
            return false;
        }
    }

    public void reset() {
        this.stopActorSystem();
        this.logger.debug("reset actor system");
        this.processExecutionSystem = ActorSystem.create((String)EXECUTION_SYSTEM_NAME);
        this.executionMaster = ProcessExecutionMasterActor.create(this.processExecutionSystem, EXECUTION_MASTER_NAME);
    }

    private void logTimeoutPortActivation(PortInstance port) {
        this.logger.error("timeout while receiving future: {}.{}", (Object)port.getProcessStepInstance().getProcessStepType().getName(), (Object)port.getName());
    }

    private void logTransition(TransitionInstance transition) {
        String source = transition.getSourcePortInstance().getName();
        String target = transition.getTargetPortInstance().getName();
        this.logger.debug("execute transition: {} --> {}", (Object)source, (Object)target);
    }

    private void logTimeoutTransitionActivation(TransitionInstance transition) {
        String source = transition.getSourcePortInstance().getName();
        String target = transition.getTargetPortInstance().getName();
        this.logger.error("timeout while receiving future: {} --> {}", (Object)source, (Object)target);
    }
}

