/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import eu.vicci.process.model.sofia.HumanTask;
import eu.vicci.process.model.sofia.HumanTaskType;
import eu.vicci.process.model.sofia.HumanTaskUseCase;
import eu.vicci.process.model.sofiainstance.DataPortInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndControlPortInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.ProcessStepInstance;
import eu.vicci.process.model.sofiainstance.SofiaInstanceFactory;
import eu.vicci.process.model.sofiainstance.StartDataPortInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import eu.vicci.process.model.sofiainstance.states.StateBase;
import eu.vicci.process.model.sofiainstance.states.WaitingState;
import eu.vicci.process.model.util.messages.HumanTaskMessageManager;
import eu.vicci.process.model.util.messages.HumanTaskMessageManagerListener;
import eu.vicci.process.model.util.messages.HumanTaskRequest;
import eu.vicci.process.model.util.messages.MessageQueue;
import eu.vicci.process.model.util.messages.core.IHumanTaskRequest;
import eu.vicci.process.model.util.messages.core.IHumanTaskResponse;
import eu.vicci.process.model.util.messages.core.IWampMessage;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.JSONProcessStepInstanceSerializer;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONDataPortInstance;
import eu.vicci.process.model.util.serialization.jsonprocessstepinstances.core.IJSONPortInstance;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CountDownLatch;

public class HumanTaskInvokeWorker
implements HumanTaskMessageManagerListener {
    public List<DataTypeInstance> returnedData = new LinkedList<DataTypeInstance>();
    private MessageQueue messageQueue;
    private CountDownLatch responseReceived;
    private IHumanTaskResponse receivedResponse;
    private String humanTaskInstanceId;

    public HumanTaskInvokeWorker(MessageQueue messageQueue) {
        if (messageQueue == null) {
            throw new IllegalArgumentException("messageQueue cant be null or human task will never finish");
        }
        this.messageQueue = messageQueue;
    }

    public List<DataTypeInstance> work(ProcessStepInstanceImplCustom hti) {
        this.responseReceived = new CountDownLatch(1);
        this.humanTaskInstanceId = hti.getInstanceId();
        HumanTask humanTask = (HumanTask)hti.getProcessStepType();
        HumanTaskRequest humanTaskRequest = this.createHumanTaskRequest((ProcessStepInstance)hti, humanTask);
        HumanTaskMessageManager.getInstance().addHumanTaskMessageManagerListener((HumanTaskMessageManagerListener)this);
        StateBase oldState = hti.getCurrentState();
        hti.setCurrentState(new WaitingState(hti));
        this.messageQueue.addMessage((IWampMessage)humanTaskRequest);
        try {
            this.responseReceived.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
        hti.setCurrentState(oldState);
        this.createDataTypeInstancesFromResponse();
        return this.returnedData;
    }

    public void onHumanTaskResponseAdded(IHumanTaskResponse response) {
        if (!this.humanTaskInstanceId.equals(response.getHumanTaskInstanceId())) {
            return;
        }
        this.receivedResponse = response;
        HumanTaskMessageManager.getInstance().removeHumanTaskMessageManagerListener((HumanTaskMessageManagerListener)this);
        this.responseReceived.countDown();
    }

    public void onHumanTaskResponseCanceled(IHumanTaskResponse oldResponse, IHumanTaskRequest request) {
    }

    private void createDataTypeInstancesFromResponse() {
        this.receivedResponse.getEndDataPorts().values().stream().forEach(port -> {
            DataTypeInstance dti = port.getDataTypeInstance().makeDataTypeInstance((SofiaInstanceFactory)SofiaInstanceFactoryImplCustom.getInstance());
            this.returnedData.add(dti);
        });
    }

    private HumanTaskRequest createHumanTaskRequest(ProcessStepInstance hti, HumanTask ht) {
        HumanTaskRequest htr = new HumanTaskRequest();
        htr.setRootProcessId(hti.getProcessModelID());
        htr.setHumanTaskInstanceId(hti.getInstanceId());
        htr.setName(ht.getName());
        htr.setDescription(ht.getDescription());
        htr.setHumanTaskType(ht.getHumanTaskType() == null ? HumanTaskType.HINT : ht.getHumanTaskType());
        htr.setHumanTaskUseCase(ht.getHumanTaskUseCase() == null ? HumanTaskUseCase.UNIVERSAL : ht.getHumanTaskUseCase());
        htr.setStartDataPorts(this.getStartDataPortInstances(hti));
        htr.setEndDataPorts(this.getEndDataPortInstances(hti));
        htr.setEndControlPorts(this.getEndControlPortInstances(hti));
        return htr;
    }

    private Map<String, IJSONDataPortInstance> getEndDataPortInstances(ProcessStepInstance hti) {
        HashMap<String, IJSONDataPortInstance> dtos = new HashMap<String, IJSONDataPortInstance>();
        hti.getPorts().stream().filter(port -> port instanceof EndDataPortInstance).forEach(port -> {
            IJSONDataPortInstance cfr_ignored_0 = (IJSONDataPortInstance)dtos.put(port.getPortType().getId(), (IJSONDataPortInstance)new JSONDataPortInstance((DataPortInstance)((EndDataPortInstance)port)));
        });
        return dtos;
    }

    private Map<String, IJSONDataPortInstance> getStartDataPortInstances(ProcessStepInstance hti) {
        HashMap<String, IJSONDataPortInstance> dtos = new HashMap<String, IJSONDataPortInstance>();
        hti.getPorts().stream().filter(port -> port instanceof StartDataPortInstance).forEach(port -> {
            IJSONDataPortInstance cfr_ignored_0 = (IJSONDataPortInstance)dtos.put(port.getPortType().getId(), (IJSONDataPortInstance)new JSONDataPortInstance((DataPortInstance)((StartDataPortInstance)port)));
        });
        return dtos;
    }

    private Map<String, IJSONPortInstance> getEndControlPortInstances(ProcessStepInstance hti) {
        HashMap<String, IJSONPortInstance> dtos = new HashMap<String, IJSONPortInstance>();
        hti.getPorts().stream().filter(port -> port instanceof EndControlPortInstance).forEach(port -> dtos.put(port.getPortType().getId(), JSONProcessStepInstanceSerializer.makeJSONPortInstance((PortInstance)port)));
        return dtos;
    }
}

