/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import eu.vicci.process.model.sofia.DataType;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.impl.custom.SofiaInstanceFactoryImplCustom;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;

public class DataTypeInstanceGenerator {
    private Map<String, Integer> dataInstanceNumbers = Collections.synchronizedMap(new HashMap());

    private DataTypeInstanceGenerator() {
    }

    public static DataTypeInstanceGenerator getInstance() {
        return GeneratorLoader.INSTANCE;
    }

    public DataTypeInstance getNewDataTypeInstance(DataType dataType) {
        if (dataType == null) {
            throw new IllegalArgumentException("the datatype of a port or a list should not be NULL. Check the process model");
        }
        DataTypeInstance typeInstance = this.createDataTypeInstance(dataType);
        String id = dataType.getId();
        int instanceNumber = this.generateInstanceNumber(dataType);
        typeInstance.setTypeId(id);
        typeInstance.setDataTypeType(dataType);
        typeInstance.setName(dataType.getName());
        typeInstance.setIdOfOrigin(id);
        typeInstance.setInstancenumber(instanceNumber);
        typeInstance.setInstanceId(id + "_Instance_" + instanceNumber);
        return typeInstance;
    }

    private synchronized int generateInstanceNumber(DataType dataType) {
        String id = dataType.getId();
        Integer out = this.dataInstanceNumbers.get(id);
        if (out == null) {
            out = 1;
        } else {
            Integer n = out;
            Integer n2 = out = Integer.valueOf(out + 1);
        }
        this.dataInstanceNumbers.put(id, out);
        return out;
    }

    private DataTypeInstance createDataTypeInstance(DataType collectionItemType) {
        int lio = collectionItemType.getClass().getSimpleName().lastIndexOf("Impl");
        if (lio < 0) {
            throw new IllegalArgumentException("can not find the correct factory method for " + collectionItemType.getClass().getSimpleName());
        }
        String split = collectionItemType.getClass().getSimpleName().substring(0, lio);
        String methodName = "create".concat(split).concat("Instance");
        DataTypeInstance instance = null;
        try {
            Method createMethod = SofiaInstanceFactoryImplCustom.class.getMethod(methodName, new Class[0]);
            Object result = createMethod.invoke((Object)SofiaInstanceFactoryImplCustom.getInstance(), new Object[0]);
            instance = (DataTypeInstance)result;
        }
        catch (IllegalAccessException | NoSuchMethodException | SecurityException | InvocationTargetException e) {
            e.printStackTrace();
            throw new IllegalArgumentException("can not find the correct factory method for " + collectionItemType.getClass().getSimpleName());
        }
        return instance;
    }

    private static class GeneratorLoader {
        static DataTypeInstanceGenerator INSTANCE = new DataTypeInstanceGenerator();

        private GeneratorLoader() {
        }
    }
}

