/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.util;

import com.google.gson.Gson;
import com.google.gson.JsonElement;
import com.google.gson.JsonObject;
import eu.vicci.process.model.sofiainstance.util.processstepclasses.Compensation;
import eu.vicci.process.model.util.configuration.ConfigurationManager;
import java.io.IOException;
import java.net.URI;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.concurrent.CountDownLatch;
import javax.ws.rs.client.Client;
import javax.ws.rs.client.ClientBuilder;
import javax.ws.rs.core.UriBuilder;
import org.apache.http.HttpEntity;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpDelete;
import org.apache.http.client.methods.HttpPost;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.entity.ContentType;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.util.EntityUtils;
import org.glassfish.jersey.media.sse.EventInput;
import org.glassfish.jersey.media.sse.InboundEvent;
import org.glassfish.jersey.media.sse.SseFeature;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CompensationWorker
implements Runnable {
    private static final Logger LOG = LoggerFactory.getLogger(Compensation.class);
    public static final String GOAL = "Goal";
    public static final String CONTEXT_URI = "ContextUri";
    public static final String SERVICE_URI = "FeedbackServiceUri";
    public static final String WORKFLOW_NAME = "WorkflowName";
    public static final String HAS_BEEN_SATISFIED = "HasBeenSatisfied";
    public static final String HAS_BEEN_FINISHED = "HasBeenFinished";
    private final Gson parser = new Gson();
    private CloseableHttpClient httpClient;
    private Client sseClient;
    private String workflowUri;
    private String serviceUri;
    private CompensationListener listener;
    private CountDownLatch waitForEvent;
    private ExecutionFlags flags = new ExecutionFlags();
    private String workflowName;
    private String contextUri;
    private Collection<String> goals = new HashSet<String>();
    private Map<String, Object> parameters = new HashMap<String, Object>();
    private String instanceId;
    private Object lock = new Object();

    @Override
    public void run() {
        this.addDefaultParameters();
        this.waitForEvent = new CountDownLatch(1);
        this.prepare();
        this.checkSettings();
        LOG.info("Start compensating feedback loop");
        this.createWorkflow();
        LOG.info(String.format("Workflow %s created", this.workflowUri));
        this.waitForEvent();
        this.createGoals();
        LOG.info("Goals created. Waiting for feedback loop");
        try {
            this.waitForEvent.await();
            LOG.info(String.format("Workflow done. Satisfaction is %s", this.flags.hasBeenSatisfied));
        }
        catch (InterruptedException e) {
            LOG.error("I'm interrupted...", (Throwable)e);
        }
        finally {
            this.deleteWorkflow();
            this.finish();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setListener(CompensationListener listener) {
        Object object = this.lock;
        synchronized (object) {
            this.listener = listener;
        }
    }

    public void setWorkflowName(String workflowName) {
        this.workflowName = workflowName;
    }

    public void setInstanceId(String instanceId) {
        this.instanceId = instanceId;
    }

    public void addGoal(String goal) {
        this.goals.add(goal);
    }

    public void addParameter(String name, Object value) {
        this.parameters.put(name, value);
    }

    public ExecutionFlags getExecutionFlags() {
        return this.flags;
    }

    private void prepare() {
        this.httpClient = HttpClients.createDefault();
        this.sseClient = ((ClientBuilder)ClientBuilder.newBuilder().register(SseFeature.class)).build();
        this.serviceUri = ConfigurationManager.getInstance().getConfigAsString("FEEDBACK_SERVICE_URI");
        this.contextUri = ConfigurationManager.getInstance().getConfigAsString("FEEDBACK_CONTEXT_URI");
    }

    private void addDefaultParameters() {
        this.addParameter("piid", this.instanceId);
    }

    private void waitForEvent() {
        new Thread(() -> {
            try {
                UriBuilder target = UriBuilder.fromPath((String)this.serviceUri).path("events").path(UriBuilder.fromPath((String)this.workflowUri).build(new Object[0]).getPath());
                EventInput eventInput = (EventInput)this.sseClient.target(target).request().get(EventInput.class);
                while (!eventInput.isClosed()) {
                    InboundEvent event = (InboundEvent)eventInput.read();
                    if (!this.workflowHasBeenDone(event.readData())) continue;
                    break;
                }
            }
            catch (Exception e) {
                LOG.error("Error while waiting for the result of the Workflow '{}'", (Object)this.workflowUri);
                e.printStackTrace();
                this.flags = new ExecutionFlags();
                this.flags.hasBeenFinished = false;
                this.flags.hasBeenSatisfied = false;
            }
            finally {
                this.waitForEvent.countDown();
            }
        }).start();
    }

    private boolean workflowHasBeenDone(String json) {
        JsonObject workflow = (JsonObject)this.parser.fromJson(json, JsonObject.class);
        this.flags.hasBeenSatisfied = workflow.get("hasBeenSatisfied").getAsBoolean();
        this.flags.hasBeenFinished = workflow.get("hasBeenFinished").getAsBoolean();
        return this.flags.hasBeenFinished || this.flags.hasBeenSatisfied;
    }

    private void createGoals() {
        JsonElement params = this.parser.toJsonTree(this.parameters);
        this.goals.stream().map(it -> (JsonObject)this.parser.fromJson(it, JsonObject.class)).forEach(it -> {
            it.addProperty("workflow", UriBuilder.fromPath((String)this.workflowUri).build(new Object[0]).toString());
            it.add("parameters", params);
            String goalUri = this.post("goals", it.toString()).get("_links").getAsJsonObject().get("self").getAsJsonObject().get("href").getAsString();
            LOG.info(String.format("Goal %s created", goalUri));
        });
    }

    private void createWorkflow() {
        JsonObject workflow = new JsonObject();
        workflow.addProperty("name", this.workflowName + "." + this.instanceId);
        workflow.addProperty("context", this.contextUri);
        this.workflowUri = this.post("workflows", workflow.toString()).get("_links").getAsJsonObject().get("self").getAsJsonObject().get("href").getAsString();
    }

    private void deleteWorkflow() {
        try {
            this.httpClient.execute((HttpUriRequest)new HttpDelete(UriBuilder.fromPath((String)this.workflowUri).build(new Object[0])));
        }
        catch (IOException exception) {
            LOG.error("cant delete workflow from fbs: {}", (Object)this.workflowUri);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void finish() {
        try {
            this.httpClient.close();
            this.sseClient.close();
        }
        catch (IOException exception) {
            LOG.error("error closing connection to fbs");
        }
        finally {
            Object object = this.lock;
            synchronized (object) {
                if (this.listener != null) {
                    this.listener.compensationFinished(this.flags);
                }
            }
        }
    }

    private JsonObject post(String path, String json) {
        URI uri = UriBuilder.fromPath((String)this.serviceUri).path(path).build(new Object[0]);
        StringEntity entity = new StringEntity(json, ContentType.APPLICATION_JSON);
        HttpPost post = new HttpPost(uri);
        post.setEntity((HttpEntity)entity);
        try {
            CloseableHttpResponse response = this.httpClient.execute((HttpUriRequest)post);
            return (JsonObject)new Gson().fromJson(EntityUtils.toString((HttpEntity)response.getEntity()), JsonObject.class);
        }
        catch (IOException exception) {
            throw new RuntimeException(exception);
        }
    }

    private void checkSettings() {
        if (this.listener == null) {
            LOG.warn("No CompensationListener listener set. Final state of compensation will be lost");
        }
        if (this.workflowName == null || this.workflowName.isEmpty()) {
            throw new RuntimeException("WorkflowName not set");
        }
        if (this.contextUri == null || this.contextUri.isEmpty()) {
            throw new RuntimeException("ContextUri not set");
        }
        if (this.serviceUri == null || this.serviceUri.isEmpty()) {
            throw new RuntimeException("Service URI not set");
        }
        if (this.instanceId == null || this.instanceId.isEmpty()) {
            throw new RuntimeException("Instance ID not set");
        }
    }

    public static class ExecutionFlags {
        public boolean hasBeenSatisfied;
        public boolean hasBeenFinished;
    }

    public static interface CompensationListener {
        public void compensationFinished(ExecutionFlags var1);
    }
}

