/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.states;

import eu.vicci.process.model.sofiainstance.BooleanTypeInstance;
import eu.vicci.process.model.sofiainstance.DataTypeInstance;
import eu.vicci.process.model.sofiainstance.EndDataPortInstance;
import eu.vicci.process.model.sofiainstance.PortInstance;
import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.DistributingProcessInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustomBase;
import eu.vicci.process.model.sofiainstance.states.EscalatedState;
import eu.vicci.process.model.sofiainstance.states.ExecutedState;
import eu.vicci.process.model.sofiainstance.states.FailedState;
import eu.vicci.process.model.sofiainstance.states.StateBase;
import eu.vicci.process.model.sofiainstance.util.CompensationWorker;
import eu.vicci.process.model.sofiainstance.util.LifeCycleManager;
import java.util.concurrent.CountDownLatch;

public class ExecutingState
extends StateBase {
    private boolean allreadyExecuted = false;
    private boolean executionSuccess = false;
    private boolean endoperationsCalled = false;
    private CompensationWorker compensationWorker;
    private CountDownLatch mWait;
    private CompensationWorker.ExecutionFlags executionFlags;
    private boolean compensationIsRunning = false;
    private final CompensationWorker.CompensationListener compensationListener = new CompensationWorker.CompensationListener(){

        @Override
        public void compensationFinished(CompensationWorker.ExecutionFlags flags) {
            ExecutingState.this.executionFlags = flags;
            ExecutingState.this.compensationIsRunning = false;
            ExecutingState.this.mWait.countDown();
            if (ExecutingState.this.processStep instanceof DistributingProcessInstanceImplCustom) {
                ((DistributingProcessInstanceImplCustom)ExecutingState.this.processStep).finishDistribution();
            }
        }
    };

    public ExecutingState(ProcessStepInstanceImplCustomBase processStep) {
        super(processStep);
    }

    @Override
    public boolean execute() {
        if (this.allreadyExecuted) {
            return this.executionSuccess;
        }
        this.allreadyExecuted = true;
        this.runCompensationIfNeeded();
        try {
            this.executionSuccess = this.processStep.onExecute();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        this.waitForCompensation();
        this.setExecutionFlagsToOutPorts();
        if (this.executionSuccess && this.processStep.allSubstepsHasFinishedExecution()) {
            if (this.processStep.allEndPortsAreDeactivatedOrActivated()) {
                this.setExecuted();
            } else {
                this.processStep.doingEndoperations();
                this.endoperationsCalled = true;
            }
        } else if (!this.executionSuccess) {
            this.processStep.setCurrentState(new FailedState(this.processStep));
        }
        return this.executionSuccess;
    }

    private void waitForCompensation() {
        if (!this.compensationIsRunning) {
            return;
        }
        try {
            this.mWait.await();
        }
        catch (InterruptedException e) {
            e.printStackTrace();
        }
    }

    private void setExecutionFlagsToOutPorts() {
        if (this.executionFlags == null) {
            return;
        }
        this.setOutValue("HasBeenSatisfied", this.executionFlags.hasBeenSatisfied);
        this.setOutValue("HasBeenFinished", this.executionFlags.hasBeenFinished);
    }

    private void setOutValue(String dtName, boolean dtValue) {
        this.processStep.getPorts().stream().filter(p -> p instanceof EndDataPortInstance).map(p -> (EndDataPortInstance)p).filter(p -> p.getDataInstance() instanceof BooleanTypeInstance).filter(p -> dtName.equals(p.getDataInstance().getName())).forEach(p -> {
            BooleanTypeInstance dti = (BooleanTypeInstance)p.getDataInstance();
            dti.setValue(dtValue);
            LifeCycleManager.INSTANCE.activatePort((PortInstance)p, (DataTypeInstance)dti);
        });
    }

    @Override
    public void processExecuted(ProcessStepInstanceImplCustom process) {
        this.setExecutedOrDoingEndoperations();
    }

    @Override
    public void portExecutionStateChanged(PortInstance port) {
        this.setExecutedOrDoingEndoperations();
    }

    @Override
    public State getSimpleState() {
        return State.EXECUTING;
    }

    @Override
    public void escalate() {
        this.processStep.onEscalate();
        this.processStep.setCurrentState(new EscalatedState(this.processStep));
        this.processStep.postEscalated();
    }

    private void setExecuted() {
        this.processStep.setCurrentState(new ExecutedState(this.processStep));
        this.processStep.postExecuted();
    }

    private boolean isAllFinished() {
        return this.processStep.allSubstepsHasFinishedExecution() && this.processStep.allEndPortsAreDeactivatedOrActivated();
    }

    private void setExecutedOrDoingEndoperations() {
        if (this.isAllFinished()) {
            this.setExecuted();
        } else if (!this.endoperationsCalled && this.processStep.allSubstepsHasFinishedExecution()) {
            this.processStep.doingEndoperations();
            this.endoperationsCalled = true;
        }
    }

    private void runCompensationIfNeeded() {
        String goal = this.processStep.getProcessStepType().getGoal();
        boolean bl = this.compensationIsRunning = goal != null && !goal.isEmpty();
        if (!this.compensationIsRunning) {
            return;
        }
        this.mWait = new CountDownLatch(1);
        this.compensationWorker = new CompensationWorker();
        this.compensationWorker.setListener(this.compensationListener);
        this.compensationWorker.setInstanceId(this.processStep.getInstanceId());
        this.compensationWorker.addGoal(goal);
        this.compensationWorker.setWorkflowName("Workflow_" + this.processStep.getProcessStepType().getName());
        Thread workerThread = new Thread(this.compensationWorker);
        workerThread.setDaemon(true);
        workerThread.setName("Compensation_" + this.processStep.getInstanceId());
        workerThread.start();
    }
}

