/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.states;

import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustomBase;
import eu.vicci.process.model.sofiainstance.states.InactiveState;
import eu.vicci.process.model.sofiainstance.states.StateBase;

public class ExecutedState
extends StateBase {
    public ExecutedState(ProcessStepInstanceImplCustomBase processStep) {
        super(processStep);
    }

    @Override
    public boolean execute() {
        return false;
    }

    @Override
    public void reset() {
        this.processStep.preReset();
        this.setInactiveIfPossible();
    }

    @Override
    public void processReset(ProcessStepInstanceImplCustom process) {
        this.setInactiveIfPossible();
    }

    @Override
    public State getSimpleState() {
        return State.EXECUTED;
    }

    @Override
    public boolean hasFinishedExecution() {
        return true;
    }

    private void setInactiveIfPossible() {
        if (this.processStep.allSubstepsAreReset()) {
            this.processStep.setCurrentState(new InactiveState(this.processStep));
            this.processStep.postReset();
        }
    }
}

