/*
 * Decompiled with CFR 0.152.
 */
package eu.vicci.process.model.sofiainstance.states;

import eu.vicci.process.model.sofiainstance.State;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustom;
import eu.vicci.process.model.sofiainstance.impl.custom.ProcessStepInstanceImplCustomBase;
import eu.vicci.process.model.sofiainstance.states.InactiveState;
import eu.vicci.process.model.sofiainstance.states.StateBase;

public class DeactivatedState
extends StateBase {
    public DeactivatedState(ProcessStepInstanceImplCustomBase processStep) {
        super(processStep);
    }

    @Override
    public boolean hasFinishedExecution() {
        return true;
    }

    @Override
    public void reset() {
        this.processStep.preReset();
        this.setInactiveIfPossible();
    }

    @Override
    public void processExecuted(ProcessStepInstanceImplCustom process) {
        if (this.processStep.allSubstepsHasFinishedExecution()) {
            this.processStep.postDeactivated();
        }
    }

    @Override
    public State getSimpleState() {
        return State.DEACTIVATED;
    }

    private void setInactiveIfPossible() {
        if (this.processStep.allSubstepsAreReset()) {
            this.processStep.setCurrentState(new InactiveState(this.processStep));
            this.processStep.postReset();
        }
    }
}

